/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class CBPanel
extends JPanel {
    GridBagLayout gridbag = new GridBagLayout();
    protected GridBagConstraints c;
    protected int xpos = 0;
    protected int ypos = 0;

    public CBPanel() {
        super(true);
        this.setLayout(this.gridbag);
        this.c = new GridBagConstraints();
        this.c.fill = 1;
        this.c.insets = new Insets(1, 1, 1, 1);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
    }

    public void makeHeavy() {
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
    }

    public void makeWide() {
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
    }

    public void makeLight() {
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
    }

    public void makeHigh() {
        this.c.weightx = 0.0;
        this.c.weighty = 1.0;
    }

    private void setXYWH(int X, int Y, int width, int height) {
        this.c.gridx = X;
        this.c.gridy = Y;
        this.c.gridwidth = width;
        this.c.gridheight = height;
    }

    public Component add(Component comp) {
        return this.add(comp, this.xpos, this.ypos, 1, 1);
    }

    public Component add(Component comp, int x, int y) {
        return this.add(comp, x, y, 1, 1);
    }

    public Component add(Component comp, int x, int y, int width, int height) {
        this.xpos = x;
        this.ypos = y;
        this.setXYWH(this.xpos, this.ypos, width, height);
        this.add(comp, this.c);
        this.ypos = y + height - 1;
        this.xpos = x + width;
        return comp;
    }

    public void newLine() {
        this.xpos = 0;
        ++this.ypos;
    }

    public void addLine(Component comp) {
        this.setXYWH(this.xpos, this.ypos, 0, 1);
        this.add(comp, this.c);
        this.newLine();
    }

    public void addln(Component comp) {
        this.addLine(comp);
    }

    public void addLines(Component comp, int height) {
        this.setXYWH(this.xpos, this.ypos, 0, height);
        this.add(comp, this.c);
        this.xpos = 0;
        this.ypos += height;
    }

    public void addWide(Component comp, int width) {
        this.setXYWH(this.xpos, this.ypos, width, 1);
        this.add(comp, this.c);
        this.xpos += width;
    }

    public void addGreedyWide(Component comp) {
        this.addGreedyWide(comp, 1);
    }

    public void addGreedyWide(Component comp, int width) {
        double oldx = this.c.weightx;
        this.c.weightx = 1.0;
        this.addWide(comp, width);
        this.c.weightx = oldx;
    }

    public String toString() {
        return "CBPanel x,y pos: " + this.xpos + "," + this.ypos + " constraint weight x,y " + this.c.weightx + "," + this.c.weighty;
    }
}

