/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.events;

import jdk.jfr.Category;
import jdk.jfr.DataAmount;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.Timespan;
import jdk.jfr.events.AbstractJDKEvent;

@Name(value="jdk.SocketRead")
@Label(value="Socket Read")
@Category(value={"Java Application"})
@Description(value="Reading data from a socket")
public final class SocketReadEvent
extends AbstractJDKEvent {
    public static final ThreadLocal<SocketReadEvent> EVENT = new ThreadLocal<SocketReadEvent>(){

        @Override
        protected SocketReadEvent initialValue() {
            return new SocketReadEvent();
        }
    };
    @Label(value="Remote Host")
    public String host;
    @Label(value="Remote Address")
    public String address;
    @Label(value="Remote Port")
    public int port;
    @Label(value="Timeout Value")
    @Timespan(value="MILLISECONDS")
    public long timeout;
    @Label(value="Bytes Read")
    @Description(value="Number of bytes read from the socket")
    @DataAmount
    public long bytesRead;
    @Label(value="End of Stream")
    @Description(value="If end of stream was reached")
    public boolean endOfStream;

    public void reset() {
        this.host = null;
        this.address = null;
        this.port = 0;
        this.timeout = 0L;
        this.bytesRead = 0L;
        this.endOfStream = false;
    }
}

