/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableExample4 {
    public TableExample4() {
        JFrame frame = new JFrame("Table");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final String[] names = new String[]{"First Name", "Last Name", "Favorite Color", "Favorite Number", "Vegetarian"};
        final Object[][] data = new Object[][]{{"Mark", "Andrews", "Red", new Integer(2), Boolean.TRUE}, {"Tom", "Ball", "Blue", new Integer(99), Boolean.FALSE}, {"Alan", "Chung", "Green", new Integer(838), Boolean.FALSE}, {"Jeff", "Dinkins", "Turquois", new Integer(8), Boolean.TRUE}, {"Amy", "Fowler", "Yellow", new Integer(3), Boolean.FALSE}, {"Brian", "Gerhold", "Green", new Integer(0), Boolean.FALSE}, {"James", "Gosling", "Pink", new Integer(21), Boolean.FALSE}, {"David", "Karlton", "Red", new Integer(1), Boolean.FALSE}, {"Dave", "Kloba", "Yellow", new Integer(14), Boolean.FALSE}, {"Peter", "Korn", "Purple", new Integer(12), Boolean.FALSE}, {"Phil", "Milne", "Purple", new Integer(3), Boolean.FALSE}, {"Dave", "Moore", "Green", new Integer(88), Boolean.FALSE}, {"Hans", "Muller", "Maroon", new Integer(5), Boolean.FALSE}, {"Rick", "Levenson", "Blue", new Integer(2), Boolean.FALSE}, {"Tim", "Prinzing", "Blue", new Integer(22), Boolean.FALSE}, {"Chester", "Rose", "Black", new Integer(0), Boolean.FALSE}, {"Ray", "Ryan", "Gray", new Integer(77), Boolean.FALSE}, {"Georges", "Saab", "Red", new Integer(4), Boolean.FALSE}, {"Willie", "Walker", "Phthalo Blue", new Integer(4), Boolean.FALSE}, {"Kathy", "Walrath", "Blue", new Integer(8), Boolean.FALSE}, {"Arnaud", "Weber", "Green", new Integer(44), Boolean.FALSE}};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names.length;
            }

            @Override
            public int getRowCount() {
                return data.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return data[row][col];
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                System.out.println("Setting value to: " + String.valueOf(aValue));
                data[row][column] = aValue;
            }
        };
        JTable tableView = new JTable(dataModel);
        tableView.setAutoResizeMode(0);
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("Red");
        comboBox.addItem("Orange");
        comboBox.addItem("Yellow");
        comboBox.addItem("Green");
        comboBox.addItem("Blue");
        comboBox.addItem("Indigo");
        comboBox.addItem("Violet");
        TableColumn colorColumn = tableView.getColumn("Favorite Color");
        colorColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer colorColumnRenderer = new DefaultTableCellRenderer();
        colorColumnRenderer.setBackground(Color.pink);
        colorColumnRenderer.setToolTipText("Click for combo box");
        colorColumn.setCellRenderer(colorColumnRenderer);
        TableCellRenderer headerRenderer = colorColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Hi Mom!");
        }
        TableColumn vegetarianColumn = tableView.getColumn("Vegetarian");
        vegetarianColumn.setPreferredWidth(100);
        TableColumn numbersColumn = tableView.getColumn("Favorite Number");
        DefaultTableCellRenderer numberColumnRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                int cellValue = value instanceof Number ? ((Number)value).intValue() : 0;
                this.setForeground(cellValue > 30 ? Color.black : Color.red);
                this.setText(value == null ? "" : value.toString());
            }
        };
        numberColumnRenderer.setHorizontalAlignment(4);
        numbersColumn.setCellRenderer(numberColumnRenderer);
        numbersColumn.setPreferredWidth(110);
        JScrollPane scrollpane = new JScrollPane(tableView);
        scrollpane.setBorder(new BevelBorder(1));
        scrollpane.setPreferredSize(new Dimension(430, 200));
        frame.getContentPane().add(scrollpane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TableExample4.class.getName()).log(Level.SEVERE, "Failed to apply Nimbus look and feel", ex);
        }
        new TableExample4();
    }
}

