/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.json.runtime;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logmanager.formatters.StructuredFormatter;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.log")
public interface JsonLogConfig {
    @ConfigDocSection
    @WithName(value="console.json")
    public JsonConfig consoleJson();

    @ConfigDocSection
    @WithName(value="file.json")
    public JsonConfig fileJson();

    @ConfigDocSection
    @WithName(value="syslog.json")
    public JsonConfig syslogJson();

    @ConfigDocSection
    @WithName(value="socket.json")
    public JsonConfig socketJson();

    @ConfigGroup
    public static interface AdditionalFieldConfig {
        public String value();

        @WithDefault(value="string")
        public Type type();

        public static enum Type {
            STRING,
            INT,
            LONG;

        }
    }

    @ConfigGroup
    public static interface JsonConfig {
        @WithParentName
        @WithDefault(value="true")
        @Deprecated(forRemoval=true, since="3.19")
        public boolean enable();

        public Optional<Boolean> enabled();

        @WithDefault(value="false")
        public boolean prettyPrint();

        @WithDefault(value="default")
        public String dateFormat();

        public Optional<String> recordDelimiter();

        @WithDefault(value="default")
        public String zoneId();

        @WithDefault(value="detailed")
        public StructuredFormatter.ExceptionOutputType exceptionOutputType();

        @WithDefault(value="false")
        public boolean printDetails();

        public Optional<String> keyOverrides();

        public Optional<Set<String>> excludedKeys();

        @ConfigDocMapKey(value="field-name")
        public Map<String, AdditionalFieldConfig> additionalField();

        @WithDefault(value="default")
        public LogFormat logFormat();

        public static enum LogFormat {
            DEFAULT,
            ECS;

        }
    }
}

