/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.Booleans;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.ReindexAction;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.transport.client.Client;

public class ReindexStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(ReindexStep.class);
    private final Client client;
    public static final String NAME = "reindex";
    private static final String REFRESH = "refresh";
    private static final String REQUESTS_PER_SECOND = "requests_per_second";
    private static final String REQUIRE_ALIAS = "require_alias";
    private static final String SLICES = "slices";
    private static final String MAX_DOCS = "max_docs";

    public ReindexStep(Client client, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.client = client;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        final PlainActionFuture reIndexFuture = PlainActionFuture.newFuture();
        Set<String> requiredKeys = Set.of("source_index", "destination_index");
        Set<String> optionalKeys = Set.of(REFRESH, REQUESTS_PER_SECOND, REQUIRE_ALIAS, SLICES, MAX_DOCS);
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            final String sourceIndices = (String)inputs.get("source_index");
            final String destinationIndex = (String)inputs.get("destination_index");
            Boolean refresh = inputs.containsKey(REFRESH) ? Boolean.valueOf(Booleans.parseBoolean((String)inputs.get(REFRESH).toString())) : null;
            Float requestsPerSecond = inputs.containsKey(REQUESTS_PER_SECOND) ? Float.valueOf(Float.parseFloat(inputs.get(REQUESTS_PER_SECOND).toString())) : null;
            requestsPerSecond = Float.valueOf(requestsPerSecond.floatValue() < 0.0f ? Float.POSITIVE_INFINITY : requestsPerSecond.floatValue());
            Boolean requireAlias = inputs.containsKey(REQUIRE_ALIAS) ? Boolean.valueOf(Booleans.parseBoolean((String)inputs.get(REQUIRE_ALIAS).toString())) : null;
            Integer slices = inputs.get(SLICES) != null ? Integer.valueOf(Integer.parseInt(String.valueOf(inputs.get(SLICES)))) : (Integer)inputs.get(SLICES);
            Integer maxDocs = inputs.get(MAX_DOCS) != null ? Integer.valueOf(Integer.parseInt(String.valueOf(inputs.get(MAX_DOCS)))) : (Integer)inputs.get(MAX_DOCS);
            ReindexRequest reindexRequest = new ReindexRequest().setSourceIndices(Strings.splitStringByCommaToArray((String)sourceIndices)).setDestIndex(destinationIndex);
            if (refresh != null) {
                reindexRequest.setRefresh(refresh.booleanValue());
            }
            if (requestsPerSecond != null) {
                reindexRequest.setRequestsPerSecond(requestsPerSecond.floatValue());
            }
            if (requireAlias != null) {
                reindexRequest.setRequireAlias(requireAlias.booleanValue());
            }
            if (maxDocs != null) {
                reindexRequest.setMaxDocs(maxDocs.intValue());
            }
            if (slices != null) {
                reindexRequest.setSlices(slices.intValue());
            }
            ActionListener<BulkByScrollResponse> actionListener = new ActionListener<BulkByScrollResponse>(this){

                public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                    logger.info("Reindex from source: {} to destination {}", (Object)sourceIndices, (Object)destinationIndex);
                    try {
                        if (bulkByScrollResponse.getBulkFailures().isEmpty() && bulkByScrollResponse.getSearchFailures().isEmpty()) {
                            reIndexFuture.onResponse((Object)new WorkflowData(Map.of(ReindexStep.NAME, Map.ofEntries(Map.entry("destination_index", destinationIndex), Map.entry("source_index", sourceIndices))), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
                        } else {
                            String errorMessage = "Failed to get bulk response " + String.valueOf(bulkByScrollResponse.getBulkFailures());
                            reIndexFuture.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.BAD_REQUEST)));
                        }
                    }
                    catch (Exception e) {
                        String errorMessage = "Failed to parse and update new created resource";
                        logger.error(errorMessage, (Throwable)e);
                        reIndexFuture.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                    }
                }

                public void onFailure(Exception e) {
                    String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to reindex from source {} to {}", (Object)sourceIndices, (Object)destinationIndex).getFormattedMessage();
                    logger.error(errorMessage, (Throwable)e);
                    reIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
                }
            };
            this.client.execute((ActionType)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, (ActionListener)actionListener);
        }
        catch (IllegalArgumentException iae) {
            String error = "Failed to reindex " + iae.getMessage();
            reIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(error, RestStatus.BAD_REQUEST)));
        }
        catch (Exception e) {
            reIndexFuture.onFailure(e);
        }
        return reIndexFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

