/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.CollectionUDF;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class ArrayFunctionImpl
extends ImplementorUDF {
    public ArrayFunctionImpl() {
        super(new ArrayImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return sqlOperatorBinding -> {
            RelDataTypeFactory typeFactory = sqlOperatorBinding.getTypeFactory();
            try {
                RelDataType originalType = SqlLibraryOperators.ARRAY.getReturnTypeInference().inferReturnType(sqlOperatorBinding);
                RelDataType innerType = originalType.getComponentType();
                return SqlTypeUtil.createArrayType((RelDataTypeFactory)typeFactory, (RelDataType)typeFactory.createTypeWithNullability(innerType, true), (boolean)true);
            }
            catch (Exception e) {
                throw new RuntimeException("fail to create array with fixed type: " + e.getMessage());
            }
        };
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return null;
    }

    public static Object internalCast(Object ... args) {
        List originalList = (List)args[0];
        SqlTypeName targetType = (SqlTypeName)args[args.length - 1];
        return switch (targetType) {
            case SqlTypeName.DECIMAL -> originalList.stream().map(num -> {
                if (num instanceof BigDecimal) {
                    return (BigDecimal)num;
                }
                return BigDecimal.valueOf(((Number)num).doubleValue());
            }).collect(Collectors.toList());
            case SqlTypeName.DOUBLE -> originalList.stream().map(i -> ((Number)i).doubleValue()).collect(Collectors.toList());
            case SqlTypeName.FLOAT -> originalList.stream().map(i -> Float.valueOf(((Number)i).floatValue())).collect(Collectors.toList());
            case SqlTypeName.VARCHAR, SqlTypeName.CHAR -> originalList.stream().map(i -> i.toString()).collect(Collectors.toList());
            default -> originalList;
        };
    }

    public static class ArrayImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            RelDataType realType = call.getType().getComponentType();
            ArrayList<Object> newArgs = new ArrayList<Object>();
            newArgs.add(Expressions.call((Method)Types.lookupMethod(Arrays.class, (String)"asList", (Class[])new Class[]{Object[].class}), translatedOperands));
            assert (realType != null);
            newArgs.add(Expressions.constant((Object)realType.getSqlTypeName()));
            return Expressions.call((Method)Types.lookupMethod(ArrayFunctionImpl.class, (String)"internalCast", (Class[])new Class[]{Object[].class}), newArgs);
        }
    }
}

