/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.error;

import lombok.Generated;
import org.json.JSONObject;
import org.opensearch.core.rest.RestStatus;

public class ErrorMessage {
    protected final Throwable exception;
    private final int status;
    private final String type;
    private final String reason;
    private final String details;

    public ErrorMessage(Throwable exception, int status) {
        this.exception = exception;
        this.status = status;
        this.type = this.fetchType();
        this.reason = this.fetchReason();
        this.details = this.fetchDetails();
    }

    private String fetchType() {
        return this.exception.getClass().getSimpleName();
    }

    protected String fetchReason() {
        return this.status == RestStatus.BAD_REQUEST.getStatus() ? "Invalid Query" : "There was internal problem at backend";
    }

    protected String fetchDetails() {
        return this.emptyStringIfNull(this.exception.getLocalizedMessage());
    }

    private String emptyStringIfNull(String str) {
        return str != null ? str : "";
    }

    public String toString() {
        JSONObject output = new JSONObject();
        output.put("status", this.status);
        output.put("error", (Object)this.getErrorAsJson());
        return output.toString(2);
    }

    private JSONObject getErrorAsJson() {
        JSONObject errorJson = new JSONObject();
        errorJson.put("type", (Object)this.type);
        errorJson.put("reason", (Object)this.reason);
        errorJson.put("details", (Object)this.details);
        return errorJson;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getDetails() {
        return this.details;
    }
}

