/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.sgd.linear;

import com.oracle.labs.mlrg.olcut.config.Config;
import java.util.logging.Logger;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.common.sgd.AbstractLinearSGDTrainer;
import org.tribuo.common.sgd.SGDObjective;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.StochasticGradientOptimiser;
import org.tribuo.math.la.DenseVector;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.sgd.RegressionObjective;
import org.tribuo.regression.sgd.linear.LinearSGDModel;

public class LinearSGDTrainer
extends AbstractLinearSGDTrainer<Regressor, DenseVector, LinearSGDModel> {
    private static final Logger logger = Logger.getLogger(LinearSGDTrainer.class.getName());
    @Config(mandatory=true, description="The regression objective to use.")
    private RegressionObjective objective;

    public LinearSGDTrainer(RegressionObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, int minibatchSize, long seed) {
        super(optimiser, epochs, loggingInterval, minibatchSize, seed);
        this.objective = objective;
    }

    public LinearSGDTrainer(RegressionObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, long seed) {
        this(objective, optimiser, epochs, loggingInterval, 1, seed);
    }

    public LinearSGDTrainer(RegressionObjective objective, StochasticGradientOptimiser optimiser, int epochs, long seed) {
        this(objective, optimiser, epochs, 1000, 1, seed);
    }

    private LinearSGDTrainer() {
    }

    protected DenseVector getTarget(ImmutableOutputInfo<Regressor> outputInfo, Regressor output) {
        double[] regressorsBuffer = new double[outputInfo.size()];
        for (Regressor.DimensionTuple r : output) {
            int id = outputInfo.getID((Output)r);
            regressorsBuffer[id] = r.getValue();
        }
        return DenseVector.createDenseVector((double[])regressorsBuffer);
    }

    protected SGDObjective<DenseVector> getObjective() {
        return this.objective;
    }

    protected LinearSGDModel createModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureMap, ImmutableOutputInfo<Regressor> outputInfo, LinearParameters parameters) {
        String[] dimensionNames = new String[outputInfo.size()];
        for (Regressor r : outputInfo.getDomain()) {
            int id = outputInfo.getID((Output)r);
            dimensionNames[id] = r.getNames()[0];
        }
        return new LinearSGDModel(name, dimensionNames, provenance, featureMap, outputInfo, parameters);
    }

    protected String getModelClassName() {
        return LinearSGDModel.class.getName();
    }

    public String toString() {
        return "LinearSGDTrainer(objective=" + this.objective.toString() + ",optimiser=" + this.optimiser.toString() + ",epochs=" + this.epochs + ",minibatchSize=" + this.minibatchSize + ",seed=" + this.seed + ")";
    }
}

