/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model;

import java.util.Optional;
import org.opensearch.search.sort.SortOrder;

public class SearchParams {
    private final int size;
    private final String sortField;
    private final SortOrder sortOrder;

    private SearchParams(Builder builder) {
        this.size = builder.size;
        this.sortField = builder.sortField;
        this.sortOrder = builder.sortOrder;
    }

    public int getSize() {
        return this.size;
    }

    public String getSortField() {
        return this.sortField;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int size = 1000;
        private String sortField = "timestamp";
        private SortOrder sortOrder = Defaults.SORT_ORDER;

        public Builder size(Integer value) {
            this.size = Optional.ofNullable(value).filter(s -> s > 0).orElse(1000);
            return this;
        }

        public Builder sortField(String field) {
            this.sortField = Optional.ofNullable(field).orElse("timestamp");
            return this;
        }

        public Builder sortOrder(String order) {
            this.sortOrder = Optional.ofNullable(order).filter("asc"::equals).map(s -> SortOrder.ASC).orElse(Defaults.SORT_ORDER);
            return this;
        }

        public SearchParams build() {
            return new SearchParams(this);
        }
    }

    private static final class Defaults {
        static final int SIZE = 1000;
        static final String SORT_FIELD = "timestamp";
        static final SortOrder SORT_ORDER = SortOrder.DESC;

        private Defaults() {
        }
    }
}

