/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LoggingMXBean;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LoggerNode;

final class LoggingMXBeanImpl
implements LoggingMXBean {
    private final LogContext context;

    LoggingMXBeanImpl(LogContext context) {
        this.context = context;
    }

    private void getAllNames(List<String> names, LoggerNode node) {
        names.add(node.getFullName());
        for (LoggerNode loggerNode : node.getChildren()) {
            if (loggerNode == null) continue;
            this.getAllNames(names, loggerNode);
        }
    }

    @Override
    public List<String> getLoggerNames() {
        LoggerNode node = this.context.getRootLoggerNode();
        ArrayList<String> names = new ArrayList<String>();
        this.getAllNames(names, node);
        return names;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        LoggerNode loggerNode = this.context.getRootLoggerNode().getIfExists(loggerName);
        Level level = loggerNode == null ? null : loggerNode.getLevel();
        return level == null ? "" : level.getName();
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        LoggerNode loggerNode = this.context.getRootLoggerNode().getIfExists(loggerName);
        if (loggerNode == null) {
            throw new IllegalArgumentException("logger \"" + loggerName + "\" does not exist");
        }
        loggerNode.setLevel(levelName == null ? null : this.context.getLevelForName(levelName));
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        int dotIdx = loggerName.lastIndexOf(46);
        if (dotIdx == -1) {
            return "";
        }
        return loggerName.substring(0, dotIdx);
    }
}

