/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

abstract class DelegatingKeyStoreSpi
extends KeyStoreSpi {
    DelegatingKeyStoreSpi() {
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.getKeyStore().getKey(alias, password);
        }
        catch (KeyStoreException e) {
            DelegatingKeyStoreSpi.exception(e, NoSuchAlgorithmException.class);
            DelegatingKeyStoreSpi.exception(e, UnrecoverableKeyException.class);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.getKeyStore().getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            return this.getKeyStore().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        try {
            return this.getKeyStore().getCreationDate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.getKeyStore().setKeyEntry(alias, key, password, chain);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.getKeyStore().setKeyEntry(alias, key, chain);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.getKeyStore().setCertificateEntry(alias, cert);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        this.getKeyStore().deleteEntry(alias);
    }

    @Override
    public Enumeration<String> engineAliases() {
        try {
            return this.getKeyStore().aliases();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        try {
            return this.getKeyStore().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int engineSize() {
        try {
            return this.getKeyStore().size();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            return this.getKeyStore().isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.getKeyStore().isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.getKeyStore().getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.getKeyStore().store(stream, password);
        }
        catch (KeyStoreException e) {
            DelegatingKeyStoreSpi.exception(e, IOException.class);
            DelegatingKeyStoreSpi.exception(e, NoSuchAlgorithmException.class);
            DelegatingKeyStoreSpi.exception(e, CertificateException.class);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.getKeyStore().load(stream, password);
    }

    protected abstract KeyStore getKeyStore();

    private static <T extends Throwable> void exception(Throwable exception, Class<T> exceptionType) throws T {
        Throwable cause = exception.getCause();
        if (exceptionType.isInstance(cause)) {
            throw (Throwable)exceptionType.cast(cause);
        }
    }
}

