/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.NameSpaceTablesInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.internal.DefaultSchemaFilter;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.IndividuallySchemaMigratorImpl;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.SchemaDropperImpl;
import org.hibernate.tool.schema.internal.exec.GenerationTarget;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public abstract class AbstractSchemaMigrator
implements SchemaMigrator {
    private static final Logger log = Logger.getLogger(IndividuallySchemaMigratorImpl.class);
    protected HibernateSchemaManagementTool tool;
    protected SchemaFilter schemaFilter;
    private UniqueConstraintSchemaUpdateStrategy uniqueConstraintStrategy;

    public AbstractSchemaMigrator(HibernateSchemaManagementTool tool, SchemaFilter schemaFilter) {
        this.tool = tool;
        this.schemaFilter = schemaFilter == null ? DefaultSchemaFilter.INSTANCE : schemaFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMigration(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, TargetDescriptor targetDescriptor) {
        SqlStringGenerationContext sqlGenerationContext = this.sqlGenerationContext(metadata, options);
        if (!targetDescriptor.getTargetTypes().isEmpty()) {
            JdbcContext jdbcContext = this.tool.resolveJdbcContext(options.getConfigurationValues());
            DdlTransactionIsolator ddlTransactionIsolator = this.tool.getDdlTransactionIsolator(jdbcContext);
            try {
                DatabaseInformation databaseInformation = Helper.buildDatabaseInformation(this.tool.getServiceRegistry(), ddlTransactionIsolator, sqlGenerationContext, this.tool);
                GenerationTarget[] targets = this.tool.buildGenerationTargets(targetDescriptor, ddlTransactionIsolator, options.getConfigurationValues());
                try {
                    for (GenerationTarget target : targets) {
                        target.prepare();
                    }
                    try {
                        this.performMigration(metadata, databaseInformation, options, contributableInclusionFilter, jdbcContext.getDialect(), sqlGenerationContext, targets);
                    }
                    finally {
                        for (GenerationTarget target : targets) {
                            try {
                                target.release();
                            }
                            catch (Exception e) {
                                log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                            }
                        }
                    }
                }
                finally {
                    try {
                        databaseInformation.cleanup();
                    }
                    catch (Exception e) {
                        log.debug((Object)("Problem releasing DatabaseInformation : " + e.getMessage()));
                    }
                }
            }
            finally {
                ddlTransactionIsolator.release();
            }
        }
    }

    private SqlStringGenerationContext sqlGenerationContext(Metadata metadata, ExecutionOptions options) {
        return SqlStringGenerationContextImpl.fromConfigurationMapForMigration(this.tool.getServiceRegistry().requireService(JdbcEnvironment.class), metadata.getDatabase(), options.getConfigurationValues());
    }

    protected abstract NameSpaceTablesInformation performTablesMigration(Metadata var1, DatabaseInformation var2, ExecutionOptions var3, ContributableMatcher var4, Dialect var5, Formatter var6, Set<String> var7, boolean var8, boolean var9, Set<Identifier> var10, Namespace var11, SqlStringGenerationContext var12, GenerationTarget[] var13);

    private void performMigration(Metadata metadata, DatabaseInformation existingDatabase, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, Dialect dialect, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        NameSpaceTablesInformation nameSpaceTablesInformation;
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        Database database = metadata.getDatabase();
        Exporter<AuxiliaryDatabaseObject> auxiliaryExporter = dialect.getAuxiliaryDatabaseObjectExporter();
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryExporter.getSqlDropStrings(auxiliaryDatabaseObject, metadata, sqlGenerationContext), formatter, options, targets);
        }
        SchemaDropperImpl.dropUserDefinedTypes(metadata, options, this.schemaFilter, dialect, formatter, sqlGenerationContext, targets);
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryExporter.getSqlCreateStrings(auxiliaryDatabaseObject, metadata, sqlGenerationContext), formatter, options, targets);
        }
        SchemaCreatorImpl.createUserDefinedTypes(metadata, options, this.schemaFilter, dialect, formatter, sqlGenerationContext, targets);
        boolean tryToCreateCatalogs = false;
        boolean tryToCreateSchemas = false;
        if (options.shouldManageNamespaces()) {
            if (dialect.canCreateSchema()) {
                tryToCreateSchemas = true;
            }
            if (dialect.canCreateCatalog()) {
                tryToCreateCatalogs = true;
            }
        }
        HashMap<Namespace, NameSpaceTablesInformation> tablesInformation = new HashMap<Namespace, NameSpaceTablesInformation>();
        HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
        for (Namespace namespace : database.getNamespaces()) {
            nameSpaceTablesInformation = this.performTablesMigration(metadata, existingDatabase, options, contributableInclusionFilter, dialect, formatter, exportIdentifiers, tryToCreateCatalogs, tryToCreateSchemas, exportedCatalogs, namespace, sqlGenerationContext, targets);
            tablesInformation.put(namespace, nameSpaceTablesInformation);
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            for (Sequence sequence : namespace.getSequences()) {
                if (!contributableInclusionFilter.matches(sequence)) continue;
                this.checkExportIdentifier(sequence, exportIdentifiers);
                SequenceInformation sequenceInformation = existingDatabase.getSequenceInformation(sequence.getName());
                if (sequenceInformation != null) continue;
                AbstractSchemaMigrator.applySequence(sequence, dialect, metadata, formatter, options, sqlGenerationContext, targets);
            }
        }
        for (Namespace namespace : database.getNamespaces()) {
            if (!this.schemaFilter.includeNamespace(namespace)) continue;
            nameSpaceTablesInformation = (NameSpaceTablesInformation)tablesInformation.get(namespace);
            for (Table table : namespace.getTables()) {
                TableInformation tableInformation;
                if (!this.schemaFilter.includeTable(table) || !contributableInclusionFilter.matches(table) || (tableInformation = nameSpaceTablesInformation.getTableInformation(table)) != null && !tableInformation.isPhysicalTable()) continue;
                this.applyForeignKeys(table, tableInformation, dialect, metadata, formatter, options, sqlGenerationContext, targets);
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            AbstractSchemaMigrator.applySqlStrings(true, auxiliaryExporter.getSqlCreateStrings(auxiliaryDatabaseObject, metadata, sqlGenerationContext), formatter, options, targets);
        }
    }

    private static void applySequence(Sequence sequence, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        AbstractSchemaMigrator.applySqlStrings(false, dialect.getSequenceExporter().getSqlCreateStrings(sequence, metadata, sqlGenerationContext), formatter, options, targets);
    }

    protected void createTable(Table table, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        AbstractSchemaMigrator.applySqlStrings(false, dialect.getTableExporter().getSqlCreateStrings(table, metadata, sqlGenerationContext), formatter, options, targets);
    }

    protected void migrateTable(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        AbstractSchemaMigrator.applySqlStrings(false, dialect.getTableMigrator().getSqlAlterStrings(table, metadata, tableInformation, sqlGenerationContext), formatter, options, targets);
    }

    protected void applyIndexes(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        Exporter<Index> exporter = dialect.getIndexExporter();
        for (Index index : table.getIndexes().values()) {
            if (StringHelper.isEmpty(index.getName())) continue;
            IndexInformation existingIndex = null;
            if (tableInformation != null) {
                existingIndex = this.findMatchingIndex(index, tableInformation);
            }
            if (existingIndex != null) continue;
            AbstractSchemaMigrator.applySqlStrings(false, exporter.getSqlCreateStrings(index, metadata, sqlGenerationContext), formatter, options, targets);
        }
    }

    private IndexInformation findMatchingIndex(Index index, TableInformation tableInformation) {
        return tableInformation.getIndex(Identifier.toIdentifier(index.getName()));
    }

    protected void applyUniqueKeys(Table table, TableInformation tableInfo, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        if (this.uniqueConstraintStrategy == null) {
            this.uniqueConstraintStrategy = this.determineUniqueConstraintSchemaUpdateStrategy();
        }
        if (this.uniqueConstraintStrategy != UniqueConstraintSchemaUpdateStrategy.SKIP) {
            Exporter<Constraint> exporter = dialect.getUniqueKeyExporter();
            for (UniqueKey uniqueKey : table.getUniqueKeys().values()) {
                IndexInformation indexInfo = null;
                if (tableInfo != null && StringHelper.isNotEmpty(uniqueKey.getName())) {
                    indexInfo = tableInfo.getIndex(Identifier.toIdentifier(uniqueKey.getName()));
                }
                if (indexInfo != null) continue;
                if (this.uniqueConstraintStrategy == UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY) {
                    AbstractSchemaMigrator.applySqlStrings(true, exporter.getSqlDropStrings(uniqueKey, metadata, sqlGenerationContext), formatter, options, targets);
                }
                AbstractSchemaMigrator.applySqlStrings(true, exporter.getSqlCreateStrings(uniqueKey, metadata, sqlGenerationContext), formatter, options, targets);
            }
        }
    }

    private UniqueConstraintSchemaUpdateStrategy determineUniqueConstraintSchemaUpdateStrategy() {
        String updateStrategy = this.tool.getServiceRegistry().requireService(ConfigurationService.class).getSetting("hibernate.schema_update.unique_constraint_strategy", StandardConverters.STRING);
        return UniqueConstraintSchemaUpdateStrategy.interpret(updateStrategy);
    }

    protected void applyForeignKeys(Table table, TableInformation tableInformation, Dialect dialect, Metadata metadata, Formatter formatter, ExecutionOptions options, SqlStringGenerationContext sqlGenerationContext, GenerationTarget ... targets) {
        if (dialect.hasAlterTable()) {
            Exporter<ForeignKey> exporter = dialect.getForeignKeyExporter();
            for (ForeignKey foreignKey : table.getForeignKeys().values()) {
                if (!foreignKey.isPhysicalConstraint() || !foreignKey.isCreationEnabled() || tableInformation != null && this.checkForExistingForeignKey(foreignKey, tableInformation)) continue;
                AbstractSchemaMigrator.applySqlStrings(false, exporter.getSqlCreateStrings(foreignKey, metadata, sqlGenerationContext), formatter, options, targets);
            }
        }
    }

    private boolean checkForExistingForeignKey(ForeignKey foreignKey, TableInformation tableInformation) {
        String referencedTable;
        if (foreignKey.getName() == null || tableInformation == null) {
            return false;
        }
        String referencingColumn = foreignKey.getColumn(0).getName();
        return this.equivalentForeignKeyExistsInDatabase(tableInformation, referencingColumn, referencedTable = foreignKey.getReferencedTable().getName()) || tableInformation.getForeignKey(Identifier.toIdentifier(foreignKey.getName())) != null;
    }

    boolean equivalentForeignKeyExistsInDatabase(TableInformation tableInformation, String referencingColumn, String referencedTable) {
        return StreamSupport.stream(tableInformation.getForeignKeys().spliterator(), false).flatMap(foreignKeyInformation -> StreamSupport.stream(foreignKeyInformation.getColumnReferenceMappings().spliterator(), false)).anyMatch(columnReferenceMapping -> {
            ColumnInformation referencingColumnMetadata = columnReferenceMapping.getReferencingColumnMetadata();
            ColumnInformation referencedColumnMetadata = columnReferenceMapping.getReferencedColumnMetadata();
            String existingReferencingColumn = referencingColumnMetadata.getColumnIdentifier().getText();
            String existingReferencedTable = referencedColumnMetadata.getContainingTableInformation().getName().getTableName().getCanonicalName();
            return referencingColumn.equalsIgnoreCase(existingReferencingColumn) && referencedTable.equalsIgnoreCase(existingReferencedTable);
        });
    }

    protected void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException(String.format("Export identifier [%s] encountered more than once", exportIdentifier));
        }
        exportIdentifiers.add(exportIdentifier);
    }

    protected static void applySqlStrings(boolean quiet, String[] sqlStrings, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (sqlStrings != null) {
            for (String sql : sqlStrings) {
                AbstractSchemaMigrator.applySqlString(quiet, sql, formatter, options, targets);
            }
        }
    }

    protected void createSchemaAndCatalog(DatabaseInformation existingDatabase, ExecutionOptions options, Dialect dialect, Formatter formatter, boolean tryToCreateCatalogs, boolean tryToCreateSchemas, Set<Identifier> exportedCatalogs, Namespace namespace, SqlStringGenerationContext context, GenerationTarget[] targets) {
        if (tryToCreateCatalogs || tryToCreateSchemas) {
            Identifier schemaPhysicalName;
            Namespace.Name logicalName = namespace.getName();
            Namespace.Name physicalName = namespace.getPhysicalName();
            if (tryToCreateCatalogs) {
                Identifier catalogLogicalName = logicalName.getCatalog();
                Identifier catalogPhysicalName = context.catalogWithDefault(physicalName.getCatalog());
                if (catalogPhysicalName != null && !exportedCatalogs.contains(catalogLogicalName) && !existingDatabase.catalogExists(catalogPhysicalName)) {
                    AbstractSchemaMigrator.applySqlStrings(false, dialect.getCreateCatalogCommand(catalogPhysicalName.render(dialect)), formatter, options, targets);
                    exportedCatalogs.add(catalogLogicalName);
                }
            }
            if (tryToCreateSchemas && (schemaPhysicalName = context.schemaWithDefault(physicalName.getSchema())) != null && !existingDatabase.schemaExists(physicalName)) {
                AbstractSchemaMigrator.applySqlStrings(false, dialect.getCreateSchemaCommand(schemaPhysicalName.render(dialect)), formatter, options, targets);
            }
        }
    }

    private static void applySqlString(boolean quiet, String sql, Formatter formatter, ExecutionOptions options, GenerationTarget ... targets) {
        if (!StringHelper.isEmpty(sql)) {
            String formattedSql = formatter.format(sql);
            for (GenerationTarget target : targets) {
                try {
                    target.accept(formattedSql);
                }
                catch (CommandAcceptanceException e) {
                    if (quiet) continue;
                    options.getExceptionHandler().handleException(e);
                }
            }
        }
    }
}

