/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.RuleBasedCollator;
import org.apache.derby.iapi.types.CollatorSQLLongvarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SQLLongvarchar
extends SQLVarchar {
    @Override
    public String getTypeName() {
        return "LONG VARCHAR";
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        try {
            return new SQLLongvarchar(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)se);
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLLongvarchar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLLongvarchar s = new CollatorSQLLongvarchar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public int getTypeFormatId() {
        return 235;
    }

    public SQLLongvarchar() {
    }

    public SQLLongvarchar(String val) {
        super(val);
    }

    @Override
    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        if (sourceValue.length() > desiredType.getMaximumWidth()) {
            throw StandardException.newException((String)"22001", (Object[])new Object[]{this.getTypeName(), StringUtil.formatForPrint(sourceValue), String.valueOf(desiredType.getMaximumWidth())});
        }
        this.setValue(sourceValue);
    }

    @Override
    public StringDataValue concatenate(StringDataValue leftOperand, StringDataValue rightOperand, StringDataValue result) throws StandardException {
        if ((result = super.concatenate(leftOperand, rightOperand, result)).getString() != null && result.getString().length() > 32700) {
            throw StandardException.newException((String)"54006", (Object[])new Object[]{"CONCAT", String.valueOf(32700)});
        }
        return result;
    }

    @Override
    public int typePrecedence() {
        return 12;
    }
}

