/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) | 12) => ivec4(-52, 76, 92, -68)
 * (ivec4(-64, 72, 88, -76) | -6) => ivec4(-6, -6, -6, -2)
 * (ivec4(-64, 72, 88, -76) | 76) => ivec4(-52, 76, 92, -4)
 * (ivec4(-64, 72, 88, -76) | -32) => ivec4(-32, -24, -8, -12)
 * (ivec4(-64, 72, 88, -76) | 0) => ivec4(-64, 72, 88, -76)
 * (ivec4(64, 72, 88, 76) | 12) => ivec4(76, 76, 92, 76)
 * (ivec4(64, 72, 88, 76) | -6) => ivec4(-6, -6, -6, -2)
 * (ivec4(64, 72, 88, 76) | 76) => ivec4(76, 76, 92, 76)
 * (ivec4(64, 72, 88, 76) | -32) => ivec4(-32, -24, -8, -20)
 * (ivec4(64, 72, 88, 76) | 0) => ivec4(64, 72, 88, 76)
 * (ivec4(-24, 40, -23, 64) | 12) => ivec4(-20, 44, -19, 76)
 * (ivec4(-24, 40, -23, 64) | -6) => ivec4(-6, -6, -5, -6)
 * (ivec4(-24, 40, -23, 64) | 76) => ivec4(-20, 108, -19, 76)
 * (ivec4(-24, 40, -23, 64) | -32) => ivec4(-24, -24, -23, -32)
 * (ivec4(-24, 40, -23, 64) | 0) => ivec4(-24, 40, -23, 64)
 * (ivec4(24, 40, 23, 64) | 12) => ivec4(28, 44, 31, 76)
 * (ivec4(24, 40, 23, 64) | -6) => ivec4(-6, -6, -1, -6)
 * (ivec4(24, 40, 23, 64) | 76) => ivec4(92, 108, 95, 76)
 * (ivec4(24, 40, 23, 64) | -32) => ivec4(-8, -24, -9, -32)
 * (ivec4(24, 40, 23, 64) | 0) => ivec4(24, 40, 23, 64)
 */
#version 130

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) | 12), ivec4(-52, 76, 92, -68))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) | -6), ivec4(-6, -6, -6, -2))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) | 76), ivec4(-52, 76, 92, -4))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) | -32), ivec4(-32, -24, -8, -12))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) | 0), ivec4(-64, 72, 88, -76))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) | 12), ivec4(76, 76, 92, 76))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) | -6), ivec4(-6, -6, -6, -2))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) | 76), ivec4(76, 76, 92, 76))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) | -32), ivec4(-32, -24, -8, -20))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) | 0), ivec4(64, 72, 88, 76))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) | 12), ivec4(-20, 44, -19, 76))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) | -6), ivec4(-6, -6, -5, -6))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) | 76), ivec4(-20, 108, -19, 76))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) | -32), ivec4(-24, -24, -23, -32))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) | 0), ivec4(-24, 40, -23, 64))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) | 12), ivec4(28, 44, 31, 76))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) | -6), ivec4(-6, -6, -1, -6))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) | 76), ivec4(92, 108, 95, 76))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) | -32), ivec4(-8, -24, -9, -32))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) | 0), ivec4(24, 40, 23, 64))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
