/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;
import org.apache.batik.apps.svgbrowser.Resources;

class WindowsAltFileSystemView
extends FileSystemView {
    public static final String EXCEPTION_CONTAINING_DIR_NULL = "AltFileSystemView.exception.containing.dir.null";
    public static final String EXCEPTION_DIRECTORY_ALREADY_EXISTS = "AltFileSystemView.exception.directory.already.exists";
    public static final String NEW_FOLDER_NAME = " AltFileSystemView.new.folder.name";
    public static final String FLOPPY_DRIVE = "AltFileSystemView.floppy.drive";
    private static final Object[] noArgs = new Object[0];
    private static final Class[] noArgTypes = new Class[0];
    private static Method listRootsMethod = null;
    private static boolean listRootsMethodChecked = false;

    WindowsAltFileSystemView() {
    }

    public boolean isRoot(File file) {
        if (!file.isAbsolute()) {
            return false;
        }
        String string = file.getParent();
        if (string == null) {
            return true;
        }
        File file2 = new File(string);
        return file2.equals(file);
    }

    public File createNewFolder(File file) throws IOException {
        if (file == null) {
            throw new IOException(Resources.getString(EXCEPTION_CONTAINING_DIR_NULL));
        }
        File file2 = null;
        file2 = this.createFileObject(file, Resources.getString(NEW_FOLDER_NAME));
        int n = 2;
        while (file2.exists() && n < 100) {
            file2 = this.createFileObject(file, Resources.getString(NEW_FOLDER_NAME) + " (" + n + ")");
            ++n;
        }
        if (file2.exists()) {
            throw new IOException(Resources.formatMessage(EXCEPTION_DIRECTORY_ALREADY_EXISTS, new Object[]{file2.getAbsolutePath()}));
        }
        file2.mkdirs();
        return file2;
    }

    public boolean isHiddenFile(File file) {
        return false;
    }

    public File[] getRoots() {
        Object[] objectArray;
        Vector<FileSystemRoot> vector = new Vector<FileSystemRoot>();
        FileSystemRoot fileSystemRoot = new FileSystemRoot(Resources.getString(FLOPPY_DRIVE) + "\\");
        vector.addElement(fileSystemRoot);
        char c = 'C';
        while (c <= 'Z') {
            objectArray = new char[]{c, ':', '\\'};
            String string = new String((char[])objectArray);
            FileSystemRoot fileSystemRoot2 = new FileSystemRoot(string);
            if (fileSystemRoot2 != null && fileSystemRoot2.exists()) {
                vector.addElement(fileSystemRoot2);
            }
            c = (char)(c + 1);
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    class FileSystemRoot
    extends File {
        public FileSystemRoot(File file) {
            super(file, "");
        }

        public FileSystemRoot(String string) {
            super(string);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

