/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ClientEsniInner;
import de.rub.nds.tlsattacker.core.protocol.serializer.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientEsniInnerSerializer
extends Serializer<ClientEsniInner> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientEsniInner clientEsniInner;

    public ClientEsniInnerSerializer(ClientEsniInner clientEsniInner) {
        this.clientEsniInner = clientEsniInner;
    }

    @Override
    protected byte[] serializeBytes() {
        LOGGER.debug("Serializing ClientEsniInner");
        this.writeNonce(this.clientEsniInner);
        this.writeServerNameListLength(this.clientEsniInner);
        this.writeServerNameListBytes(this.clientEsniInner);
        this.writePadding(this.clientEsniInner);
        return this.getAlreadySerialized();
    }

    private void writeNonce(ClientEsniInner msg) {
        this.appendBytes((byte[])msg.getClientNonce().getValue());
        LOGGER.debug("Nonce: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getClientNonce().getValue())));
    }

    private void writeServerNameListLength(ClientEsniInner msg) {
        this.appendInt((Integer)this.clientEsniInner.getServerNameListLength().getValue(), 2);
        LOGGER.debug("ServerNameListLength: " + msg.getServerNameListLength().getValue());
    }

    private void writeServerNameListBytes(ClientEsniInner msg) {
        this.appendBytes((byte[])this.clientEsniInner.getServerNameListBytes().getValue());
        LOGGER.debug("ServerNameListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getServerNameListBytes().getValue())));
    }

    private void writePadding(ClientEsniInner msg) {
        this.appendBytes((byte[])this.clientEsniInner.getPadding().getValue());
        LOGGER.debug("Padding: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPadding().getValue())));
    }
}

