/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.instrumentation.CPExtensionsRepository;
import org.graalvm.visualvm.lib.jfluid.instrumentation.Injector;

class CodeRegionEntryExitCallsInjector
extends Injector
implements CommonConstants {
    protected static byte[] injectedCode;
    protected static int injectedCodeLen;
    protected static int injectedCodeMethodIdxPos;
    protected int bci0;
    protected int bci1;

    CodeRegionEntryExitCallsInjector(DynamicClassInfo clazz, int baseCPoolCount, int methodIdx, int bci0, int bci1) {
        super(clazz, methodIdx);
        this.baseCPoolCount = baseCPoolCount;
        this.bci0 = bci0;
        this.bci1 = bci1;
    }

    @Override
    public byte[] instrumentMethod() {
        int firstRetIdx = -1;
        int totalReturns = 0;
        int lastInstrIdx = -1;
        for (int bci = 0; bci <= this.bci1; bci += this.opcodeLength(bci)) {
            int bc = this.bytecodes[bci] & 0xFF;
            ++lastInstrIdx;
            if (bc < 172 || bc > 177) continue;
            if (bci >= this.bci0 && firstRetIdx == -1) {
                firstRetIdx = totalReturns;
            }
            ++totalReturns;
        }
        this.injectCodeRegionEntry();
        this.injectCodeRegionExits(firstRetIdx, totalReturns, lastInstrIdx += 2);
        return this.createPackedMethodInfo();
    }

    private static void initializeInjectedCode() {
        injectedCodeLen = 4;
        injectedCode = new byte[injectedCodeLen];
        CodeRegionEntryExitCallsInjector.injectedCode[0] = -72;
        injectedCodeMethodIdxPos = 1;
        CodeRegionEntryExitCallsInjector.injectedCode[3] = 0;
    }

    private void injectCodeRegionEntry() {
        int targetMethodIdx = CPExtensionsRepository.codeRegionContents_CodeRegionEntryMethodIdx + this.baseCPoolCount;
        CodeRegionEntryExitCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, targetMethodIdx);
        this.injectCodeAndRewrite(injectedCode, injectedCodeLen, this.bci0, true);
    }

    private void injectCodeRegionExits(int firstRetIdx, int totalReturns, int lastInstrIdx) {
        int targetMethodIdx = CPExtensionsRepository.codeRegionContents_CodeRegionExitMethodIdx + this.baseCPoolCount;
        CodeRegionEntryExitCallsInjector.putU2(injectedCode, injectedCodeMethodIdxPos, targetMethodIdx);
        int curInstrIdx = -1;
        if (firstRetIdx != -1) {
            block0: for (int inFragmentRetIndex = firstRetIdx; inFragmentRetIndex < totalReturns; ++inFragmentRetIndex) {
                int curRetIdx = -1;
                curInstrIdx = -1;
                for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
                    ++curInstrIdx;
                    int bc = this.bytecodes[bci] & 0xFF;
                    if (bc < 172 || bc > 177 || ++curRetIdx != inFragmentRetIndex) continue;
                    this.injectCodeAndRewrite(injectedCode, injectedCodeLen, bci, true);
                    lastInstrIdx += 2;
                    continue block0;
                }
            }
        }
        if (curInstrIdx == lastInstrIdx) {
            return;
        }
        curInstrIdx = -1;
        for (int bci = 0; bci < this.bytecodesLength; bci += this.opcodeLength(bci)) {
            if (++curInstrIdx < lastInstrIdx) continue;
            this.injectCodeAndRewrite(injectedCode, injectedCodeLen, bci, true);
            break;
        }
    }

    static {
        CodeRegionEntryExitCallsInjector.initializeInjectedCode();
    }
}

