/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation.http;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.component.split.request.RequestSplitComponent;
import org.zaproxy.zap.extension.httppanel.component.split.response.ResponseSplitComponent;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.HttpPanelManager;
import org.zaproxy.zap.view.messagelocation.SelectMessageLocationsPanel;
import org.zaproxy.zap.view.messagelocation.http.DefaultHttpMessageLocationsPanel;

public class HttpMessageLocationsPanel
extends JPanel {
    private static final long serialVersionUID = -5501414760564977715L;
    private DefaultHttpMessageLocationsPanel locationsPanel;
    private SelectMessageLocationsPanel selectMessageLocationsPanel;
    private boolean request;

    public HttpMessageLocationsPanel(boolean request, HttpMessage message, String locationsLabel) {
        super(new BorderLayout());
        this.request = request;
        this.selectMessageLocationsPanel = new SelectMessageLocationsPanel();
        if (request) {
            this.selectMessageLocationsPanel.addComponent(new RequestSplitComponent(), new ZapXmlConfiguration());
            HttpPanelManager.getInstance().addRequestPanel(this.selectMessageLocationsPanel);
        } else {
            this.selectMessageLocationsPanel.addComponent(new ResponseSplitComponent(), new ZapXmlConfiguration());
            HttpPanelManager.getInstance().addResponsePanel(this.selectMessageLocationsPanel);
        }
        this.selectMessageLocationsPanel.setMessage(message, true);
        this.locationsPanel = new DefaultHttpMessageLocationsPanel(this, this.selectMessageLocationsPanel);
        this.selectMessageLocationsPanel.addFocusListener(this.locationsPanel.getFocusListenerAddButtonEnabler());
        this.setLayout(new BorderLayout());
        JPanel rightPanel = new JPanel();
        GroupLayout leftPanelLayout = new GroupLayout(rightPanel);
        rightPanel.setLayout(leftPanelLayout);
        leftPanelLayout.setAutoCreateGaps(true);
        leftPanelLayout.setAutoCreateContainerGaps(true);
        JLabel locLabel = new JLabel(locationsLabel);
        leftPanelLayout.setHorizontalGroup(leftPanelLayout.createParallelGroup().addComponent(locLabel).addComponent(this.locationsPanel));
        leftPanelLayout.setVerticalGroup(leftPanelLayout.createSequentialGroup().addComponent(locLabel).addComponent(this.locationsPanel));
        JSplitPane splitPane = new JSplitPane(1, this.selectMessageLocationsPanel, rightPanel);
        splitPane.setResizeWeight(0.6);
        this.add(splitPane);
    }

    public boolean setSelectedContainer(String containerName) {
        if (containerName == null || containerName.isEmpty()) {
            throw new IllegalArgumentException("Parameter containerName must not be null nor empty.");
        }
        return this.selectMessageLocationsPanel.setSelectedView(containerName);
    }

    public boolean addMessageLocation(MessageLocation messageLocation) {
        if (messageLocation == null) {
            throw new IllegalArgumentException("Parameter messageLocation must not be null.");
        }
        return this.locationsPanel.addMessageLocation(messageLocation);
    }

    public void clear() {
        if (this.request) {
            HttpPanelManager.getInstance().removeRequestPanel(this.selectMessageLocationsPanel);
        } else {
            HttpPanelManager.getInstance().removeResponsePanel(this.selectMessageLocationsPanel);
        }
    }

    public List<MessageLocation> getLocations() {
        return this.locationsPanel.getLocations();
    }
}

