/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise.client;

import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.enterprise.client.GroupMember;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.security.GrantedAuthority;

public class Group
extends AbstractSPObject
implements GrantedAuthority {
    public static List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(GroupMember.class, Grant.class)));
    private final List<Grant> grants = new ArrayList<Grant>();
    private final List<GroupMember> members = new ArrayList<GroupMember>();

    @Constructor
    public Group(@ConstructorParameter(propertyName="name") String name) {
        this.setName(name);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof Grant) {
            return this.removeGrant((Grant)child);
        }
        if (child instanceof GroupMember) {
            return this.removeMember((GroupMember)child);
        }
        return false;
    }

    @NonProperty
    public List<SPObject> getChildren() {
        ArrayList<SPObject> children = new ArrayList<SPObject>();
        children.addAll(this.members);
        children.addAll(this.grants);
        return children;
    }

    @Override
    @NonProperty
    public <T extends SPObject> List<T> getChildren(Class<T> type) {
        ArrayList<AbstractSPObject> children = new ArrayList<AbstractSPObject>();
        if (type.isAssignableFrom(Grant.class)) {
            children.addAll(this.grants);
        }
        if (type.isAssignableFrom(GroupMember.class)) {
            children.addAll(this.members);
        }
        return children;
    }

    @NonProperty
    public List<SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
    }

    public void addGrant(Grant grant) {
        this.addGrant(grant, this.grants.size());
    }

    public void addGrant(Grant grant, int index) {
        this.grants.add(index, grant);
        grant.setParent(this);
        this.fireChildAdded(Grant.class, grant, index);
    }

    public boolean removeGrant(Grant grant) {
        boolean wasRemoved = false;
        if (this.grants.contains(grant)) {
            int index = this.grants.indexOf(grant);
            wasRemoved = this.grants.remove(grant);
            this.fireChildRemoved(Grant.class, grant, index);
            grant.setParent(null);
        }
        return wasRemoved;
    }

    public void addMember(GroupMember member, int index) {
        this.members.add(index, member);
        member.setParent(this);
        this.fireChildAdded(GroupMember.class, member, index);
    }

    public void addMember(GroupMember member) {
        this.addMember(member, this.members.size());
    }

    public void addUser(User user) {
        this.addMember(new GroupMember(user));
    }

    public boolean removeMember(GroupMember member) {
        boolean wasRemoved = false;
        if (this.members.contains(member)) {
            int index = this.members.indexOf(member);
            wasRemoved = this.members.remove(member);
            this.fireChildRemoved(GroupMember.class, member, index);
            member.setParent(null);
        }
        return wasRemoved;
    }

    public boolean removeUser(User user) {
        for (GroupMember member : this.members) {
            if (!member.getUser().getUUID().equals(user.getUUID())) continue;
            return this.removeMember(member);
        }
        return false;
    }

    @Transient
    @Accessor
    public String getAuthority() {
        return super.getName();
    }

    public int compareTo(Object o) {
        assert (o instanceof GrantedAuthority);
        return ((GrantedAuthority)o).getAuthority().compareTo(this.getAuthority());
    }

    @Override
    public String toString() {
        return super.getName();
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof GroupMember) {
            this.addMember((GroupMember)child, index);
        } else if (child instanceof Grant) {
            this.addGrant((Grant)child, index);
        } else {
            throw new IllegalArgumentException("Group does not accept this child: " + child);
        }
    }

    @Override
    @NonProperty
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        ArrayList<Class<? extends SPObject>> childTypes = new ArrayList<Class<? extends SPObject>>();
        childTypes.add(GroupMember.class);
        childTypes.add(Grant.class);
        return childTypes;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        throw new NotSerializableException();
    }

    private void writeObject(ObjectOutputStream ois) throws IOException {
        throw new NotSerializableException();
    }

    public static enum SPObjectOrder {
        GROUP_MEMBER(GroupMember.class, new Class[0]),
        GRANT(Grant.class, new Class[0]);

        private final Class<? extends SPObject> superChildClass;
        private final Set<Class<? extends SPObject>> classes;

        private SPObjectOrder(Class<? extends SPObject> superChildClass, Class<? extends SPObject> ... classes) {
            this.superChildClass = superChildClass;
            this.classes = new HashSet<Class<? extends SPObject>>(Arrays.asList(classes));
        }

        public Class<? extends SPObject> getSuperChildClass() {
            return this.superChildClass;
        }

        public Set<Class<? extends SPObject>> getChildClasses() {
            return Collections.unmodifiableSet(this.classes);
        }

        public static SPObjectOrder getOrderBySimpleClassName(String name) {
            for (SPObjectOrder order : SPObjectOrder.values()) {
                if (order.getSuperChildClass().getSimpleName().equals(name)) {
                    return order;
                }
                for (Class<? extends SPObject> childClass : order.getChildClasses()) {
                    if (!childClass.getSimpleName().equals(name)) continue;
                    return order;
                }
            }
            throw new IllegalArgumentException("The " + SPObject.class.getSimpleName() + " class \"" + name + "\" does not exist or is not a child type " + "of " + Group.class.getSimpleName() + ".");
        }
    }
}

