/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpdelete;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.File;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftpdelete.Messages;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFTPDelete
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Logger log4j = Logger.getLogger(JobEntryFTPDelete.class);
    private String serverName;
    private String port;
    private String userName;
    private String password;
    private String ftpDirectory;
    private String wildcard;
    private int timeout;
    private boolean activeConnection;
    private boolean publicpublickey;
    private String keyFilename;
    private String keyFilePass;
    private boolean useproxy;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String protocol;
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_ALL_FILES_DOWNLOADED = "success_is_all_files_downloaded";
    private String nr_limit_success;
    private String success_condition;
    private boolean copyprevious;
    long NrErrors = 0L;
    long NrfilesDeleted = 0L;
    boolean successConditionBroken = false;
    String targetFilename = null;
    int limitFiles = 0;
    FTPClient ftpclient = null;
    SFTPClient sftpclient = null;
    SFTPv3Client sshclient = null;

    public JobEntryFTPDelete(String n) {
        super(n, "");
        this.copyprevious = false;
        this.protocol = "FTP";
        this.port = "21";
        this.nr_limit_success = "10";
        this.success_condition = this.SUCCESS_IF_ALL_FILES_DOWNLOADED;
        this.publicpublickey = false;
        this.keyFilename = null;
        this.keyFilePass = null;
        this.serverName = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.FTP_DELETE);
    }

    public JobEntryFTPDelete() {
        this("");
    }

    public JobEntryFTPDelete(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryFTPDelete je = (JobEntryFTPDelete)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useproxy", (boolean)this.useproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)this.proxyPassword));
        retval.append("      ").append(XMLHandler.addTagValue((String)"publicpublickey", (boolean)this.publicpublickey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)this.keyFilePass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit_success", (String)this.nr_limit_success));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"copyprevious", (boolean)this.copyprevious));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.protocol = XMLHandler.getTagValue((Node)entrynode, (String)"protocol");
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.useproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"useproxy"));
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password");
            this.publicpublickey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"publicpublickey"));
            this.keyFilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePass = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass");
            this.nr_limit_success = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit_success");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.copyprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ftp' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.protocol = rep.getJobEntryAttributeString(id_jobentry, "protocol");
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.copyprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "copyprevious");
            this.useproxy = rep.getJobEntryAttributeBoolean(id_jobentry, "useproxy");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = rep.getJobEntryAttributeString(id_jobentry, "proxy_password");
            this.publicpublickey = rep.getJobEntryAttributeBoolean(id_jobentry, "publicpublickey");
            this.keyFilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyFilePass = rep.getJobEntryAttributeString(id_jobentry, "keyfilepass");
            this.nr_limit_success = rep.getJobEntryAttributeString(id_jobentry, "nr_limit_success");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'ftp' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "protocol", this.protocol);
            rep.saveJobEntryAttribute(id_job, this.getID(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getID(), "copyprevious", this.copyprevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "useproxy", this.useproxy);
            rep.saveJobEntryAttribute(id_job, this.getID(), "publicpublickey", this.publicpublickey);
            rep.saveJobEntryAttribute(id_job, this.getID(), "keyfilename", this.keyFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "keyfilepass", this.keyFilePass);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "proxy_password", this.proxyPassword);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_limit_success", this.nr_limit_success);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ftp' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    private boolean getStatus() {
        boolean retval = false;
        if (this.NrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_ALL_FILES_DOWNLOADED) || this.NrfilesDeleted >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.NrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    public boolean isCopyPrevious() {
        return this.copyprevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyprevious = copyprevious;
    }

    public void setUsePublicKey(boolean publickey) {
        this.publicpublickey = publickey;
    }

    public boolean isUsePublicKey() {
        return this.publicpublickey;
    }

    public void setKeyFilename(String keyfilename) {
        this.keyFilename = keyfilename;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public void setKeyFilePass(String keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public String getKeyFilePass() {
        return this.keyFilePass;
    }

    public void setLimitSuccess(String nr_limit_successin) {
        this.nr_limit_success = nr_limit_successin;
    }

    public String getLimitSuccess() {
        return this.nr_limit_success;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public void setUseProxy(boolean useproxy) {
        this.useproxy = useproxy;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block72: {
            Exception e22222222;
            String[] filelist;
            HashSet<String> list_previous_files;
            List rows;
            RowMetaAndData resultRow;
            LogWriter log;
            block64: {
                Exception e22222222;
                int found;
                Object vfilelist;
                log = LogWriter.getInstance();
                log4j.info((Object)Messages.getString("JobEntryFTPDelete.Started", this.serverName));
                resultRow = null;
                result = previousResult;
                rows = result.getRows();
                result.setResult(false);
                this.NrErrors = 0L;
                this.NrfilesDeleted = 0L;
                this.successConditionBroken = false;
                list_previous_files = new HashSet<String>();
                String realservername = this.environmentSubstitute(this.serverName);
                String realserverpassword = this.environmentSubstitute(this.password);
                String realFtpDirectory = this.environmentSubstitute(this.ftpDirectory);
                int realserverport = Const.toInt((String)this.environmentSubstitute(this.port), (int)0);
                String realUsername = this.environmentSubstitute(this.userName);
                String realPassword = this.environmentSubstitute(this.password);
                String realproxyhost = this.environmentSubstitute(this.proxyHost);
                String realproxyusername = this.environmentSubstitute(this.proxyUsername);
                String realproxypassword = this.environmentSubstitute(this.proxyPassword);
                int realproxyport = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)0);
                String realkeyFilename = this.environmentSubstitute(this.keyFilename);
                String realkeyPass = this.environmentSubstitute(this.keyFilePass);
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.Start"), new Object[0]);
                }
                if (this.copyprevious && rows.size() == 0) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.ArgsFromPreviousNothing"), new Object[0]);
                    }
                    result.setResult(true);
                    return result;
                }
                filelist = null;
                if (this.protocol.equals("FTP")) {
                    String translatedWildcard;
                    this.FTPConnect(log, realservername, realUsername, realPassword, realserverport, realFtpDirectory, realproxyhost, realproxyusername, realproxypassword, realproxyport, this.timeout);
                    filelist = this.ftpclient.dir();
                    if (filelist.length == 1 && !Const.isEmpty((String)(translatedWildcard = this.environmentSubstitute(this.wildcard))) && filelist[0].startsWith(translatedWildcard)) {
                        throw new FTPException(filelist[0]);
                    }
                } else if (this.protocol.equals("SFTP")) {
                    this.SFTPConnect(log, realservername, realUsername, realserverport, realPassword, realFtpDirectory);
                    filelist = this.sftpclient.dir();
                } else if (this.protocol.equals("SSH")) {
                    this.SSHConnect(log, realservername, realserverpassword, realserverport, realUsername, realPassword, realproxyhost, realproxyusername, realproxypassword, realproxyport, realkeyFilename, realkeyPass);
                    String sourceFolder = ".";
                    sourceFolder = realFtpDirectory != null ? realFtpDirectory + "/" : "./";
                    vfilelist = this.sshclient.ls(sourceFolder);
                    int i = 0;
                    if (vfilelist != null) {
                        filelist = new String[((Vector)vfilelist).size()];
                        Iterator iterator = ((Vector)vfilelist).iterator();
                        while (iterator.hasNext()) {
                            SFTPv3DirectoryEntry dirEntry = (SFTPv3DirectoryEntry)iterator.next();
                            if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..") || this.isDirectory(this.sshclient, sourceFolder + dirEntry.filename)) continue;
                            filelist[i++] = dirEntry.filename;
                        }
                    }
                }
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "JobEntryFTPDelete.FoundNFiles", new Object[]{"" + filelist.length});
                }
                int n = found = filelist == null ? 0 : filelist.length;
                if (found != 0) break block64;
                result.setResult(true);
                vfilelist = result;
                Object var29_34 = null;
                if (this.ftpclient != null && this.ftpclient.connected()) {
                    try {
                        this.ftpclient.quit();
                        this.ftpclient = null;
                    }
                    catch (Exception e22222222) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                    }
                }
                if (this.sftpclient != null) {
                    try {
                        this.sftpclient.disconnect();
                        this.sftpclient = null;
                    }
                    catch (Exception e22222222) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                    }
                }
                if (this.sshclient != null) {
                    try {
                        this.sshclient.close();
                        this.sshclient = null;
                    }
                    catch (Exception e22222222) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                    }
                }
                return vfilelist;
            }
            try {
                Pattern pattern = null;
                if (this.copyprevious) {
                    for (int iteration = 0; iteration < rows.size(); ++iteration) {
                        resultRow = (RowMetaAndData)rows.get(iteration);
                        String file_previous = resultRow.getString(0, null);
                        if (Const.isEmpty((String)file_previous)) continue;
                        list_previous_files.add(file_previous);
                    }
                } else if (!Const.isEmpty((String)this.wildcard)) {
                    String realWildcard = this.environmentSubstitute(this.wildcard);
                    pattern = Pattern.compile(realWildcard);
                }
                if (!this.getSuccessCondition().equals(this.SUCCESS_IF_ALL_FILES_DOWNLOADED)) {
                    this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimitSuccess()), (int)10);
                }
                for (int i = 0; i < filelist.length && !parentJob.isStopped(); ++i) {
                    if (this.successConditionBroken) {
                        throw new Exception(Messages.getString("JobEntryFTPDelete.SuccesConditionBroken"));
                    }
                    boolean getIt = false;
                    if (log.isDebug()) {
                        log.logDebug(this.toString(), Messages.getString("JobEntryFTPDelete.AnalysingFile", filelist[i]), new Object[0]);
                    }
                    try {
                        if (this.copyprevious) {
                            if (list_previous_files.contains(filelist[i])) {
                                getIt = true;
                            }
                        } else if (pattern != null) {
                            Matcher matcher = pattern.matcher(filelist[i]);
                            getIt = matcher.matches();
                        }
                        if (!getIt) continue;
                        if (this.protocol.equals("FTP")) {
                            this.ftpclient.delete(filelist[i]);
                        } else if (this.protocol.equals("SFTP")) {
                            this.sftpclient.delete(filelist[i]);
                        } else if (this.protocol.equals("SSH")) {
                            this.sshclient.rm(filelist[i]);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "JobEntryFTPDelete.RemotfileDeleted", new Object[]{filelist[i]});
                        }
                        this.updateDeletedFiles();
                        continue;
                    }
                    catch (Exception e3) {
                        this.updateErrors();
                        log.logError(this.toString(), Messages.getString("JobFTP.UnexpectedError", e3.getMessage()), new Object[0]);
                        if (!this.successConditionBroken) continue;
                        throw new Exception(Messages.getString("JobEntryFTPDelete.SuccesConditionBroken"));
                    }
                }
                Object var29_35 = null;
            }
            catch (Throwable throwable) {
                Exception e22222222;
                Object var29_37 = null;
                if (this.ftpclient != null && this.ftpclient.connected()) {
                    try {
                        this.ftpclient.quit();
                        this.ftpclient = null;
                    }
                    catch (Exception e22222222) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                    }
                }
                if (this.sftpclient != null) {
                    try {
                        this.sftpclient.disconnect();
                        this.sftpclient = null;
                    }
                    catch (Exception e22222222) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                    }
                }
                if (this.sshclient != null) {
                    try {
                        this.sshclient.close();
                        this.sshclient = null;
                    }
                    catch (Exception e22222222) {
                        log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                    }
                }
                throw throwable;
            }
            if (this.ftpclient != null && this.ftpclient.connected()) {
                try {
                    this.ftpclient.quit();
                    this.ftpclient = null;
                }
                catch (Exception e22222222) {
                    log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                }
            }
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                    this.sftpclient = null;
                }
                catch (Exception e22222222) {
                    log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                }
            }
            if (this.sshclient != null) {
                try {
                    this.sshclient.close();
                    this.sshclient = null;
                }
                catch (Exception e22222222) {
                    log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                }
            }
            break block72;
            {
                catch (Exception e4) {
                    Exception e22222222;
                    this.updateErrors();
                    log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorGetting", e4.getMessage()), new Object[0]);
                    log.logError(this.toString(), Const.getStackTracker((Throwable)e4), new Object[0]);
                    Object var29_36 = null;
                    if (this.ftpclient != null && this.ftpclient.connected()) {
                        try {
                            this.ftpclient.quit();
                            this.ftpclient = null;
                        }
                        catch (Exception e22222222) {
                            log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                        }
                    }
                    if (this.sftpclient != null) {
                        try {
                            this.sftpclient.disconnect();
                            this.sftpclient = null;
                        }
                        catch (Exception e22222222) {
                            log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                        }
                    }
                    if (this.sshclient != null) {
                        try {
                            this.sshclient.close();
                            this.sshclient = null;
                        }
                        catch (Exception e22222222) {
                            log.logError(this.toString(), Messages.getString("JobEntryFTPDelete.ErrorQuitting", e22222222.getMessage()), new Object[0]);
                        }
                    }
                }
            }
        }
        result.setResult(!this.successConditionBroken);
        result.setNrFilesRetrieved(this.NrfilesDeleted);
        result.setNrErrors(this.NrErrors);
        return result;
    }

    public boolean isDirectory(SFTPv3Client sftpClient, String filename) {
        try {
            return sftpClient.stat(filename).isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void SSHConnect(LogWriter log, String realservername, String realserverpassword, int realserverport, String realUsername, String realPassword, String realproxyhost, String realproxyusername, String realproxypassword, int realproxyport, String realkeyFilename, String realkeyPass) throws Exception {
        Connection conn = new Connection(realservername, realserverport);
        if (this.useproxy) {
            conn.setProxyData((ProxyData)new HTTPProxyData(realproxyhost, realproxyport));
            if (!Const.isEmpty((String)realproxyusername) || !Const.isEmpty((String)realproxypassword)) {
                conn.setProxyData((ProxyData)new HTTPProxyData(realproxyhost, realproxyport, realproxyusername, realproxypassword));
            }
        }
        if (this.timeout > 0) {
            conn.connect(null, 0, this.timeout * 1000);
        } else {
            conn.connect();
        }
        boolean isAuthenticated = false;
        isAuthenticated = this.publicpublickey ? conn.authenticateWithPublicKey(realUsername, new File(this.keyFilename), realkeyPass) : conn.authenticateWithPassword(realUsername, realserverpassword);
        if (!isAuthenticated) {
            throw new Exception("Can not connect to ");
        }
        this.sshclient = new SFTPv3Client(conn);
    }

    private void SFTPConnect(LogWriter log, String realservername, String realusername, int realport, String realpassword, String realFTPDirectory) throws Exception {
        this.sftpclient = new SFTPClient(InetAddress.getByName(realservername), realport, realusername);
        this.sftpclient.login(realpassword);
        if (!Const.isEmpty((String)realFTPDirectory)) {
            this.sftpclient.chdir(realFTPDirectory);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), "Changed to directory [" + realFTPDirectory + "]", new Object[0]);
            }
        }
    }

    private void FTPConnect(LogWriter log, String realServername, String realusername, String realpassword, int realport, String realFtpDirectory, String realProxyhost, String realproxyusername, String realproxypassword, int realproxyport, int realtimeout) throws Exception {
        this.ftpclient = new FTPClient();
        this.ftpclient.setRemoteAddr(InetAddress.getByName(realServername));
        if (realport != 0) {
            this.ftpclient.setRemotePort(realport);
        }
        if (!Const.isEmpty((String)realProxyhost)) {
            this.ftpclient.setRemoteAddr(InetAddress.getByName(realProxyhost));
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.OpenedProxyConnectionOn", realProxyhost), new Object[0]);
            }
            if (realproxyport != 0) {
                this.ftpclient.setRemotePort(realproxyport);
            }
        } else {
            this.ftpclient.setRemoteAddr(InetAddress.getByName(realServername));
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.OpenedConnectionTo", realServername), new Object[0]);
            }
        }
        if (this.activeConnection) {
            this.ftpclient.setConnectMode(FTPConnectMode.ACTIVE);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.SetActive"), new Object[0]);
            }
        } else {
            this.ftpclient.setConnectMode(FTPConnectMode.PASV);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.SetPassive"), new Object[0]);
            }
        }
        this.ftpclient.setTimeout(realtimeout);
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.SetTimeout", String.valueOf(realtimeout)), new Object[0]);
        }
        this.ftpclient.connect();
        String realUsername = realusername + (!Const.isEmpty((String)realProxyhost) ? "@" + realServername : "") + (!Const.isEmpty((String)realproxyusername) ? " " + realproxyusername : "");
        String realPassword = realpassword + (!Const.isEmpty((String)realproxypassword) ? " " + realproxypassword : "");
        this.ftpclient.login(realUsername, realPassword);
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.LoggedIn", realUsername), new Object[0]);
        }
        if (!Const.isEmpty((String)realFtpDirectory)) {
            this.ftpclient.chdir(realFtpDirectory);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryFTPDelete.ChangedDir", realFtpDirectory), new Object[0]);
            }
        }
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (!this.getStatus()) {
            this.successConditionBroken = true;
        }
    }

    private void updateDeletedFiles() {
        ++this.NrfilesDeleted;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean passive) {
        this.activeConnection = passive;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "targetDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServername = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }
}

