/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.TokenMap;
import org.fife.ui.rtextarea.Marker;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.decompiler.StringBuilderPrinter;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.view.component.ClassFilePage;
import org.jd.gui.view.component.HyperlinkPage;
import org.jd.gui.view.component.TypePage;

public class ModuleInfoFilePage
extends ClassFilePage {
    public static final String SYNTAX_STYLE_JAVA_MODULE = "text/java-module";

    public ModuleInfoFilePage(API api, Container.Entry entry) {
        super(api, entry);
    }

    @Override
    public void decompile(Map<String, String> preferences) {
        try {
            this.clearHyperlinks();
            this.clearLineNumbers();
            this.typeDeclarations.clear();
            boolean unicodeEscape = ModuleInfoFilePage.getPreferenceValue(preferences, "ClassFileDecompilerPreferences.escapeUnicodeCharacters", false);
            ContainerLoader loader = new ContainerLoader(this.entry);
            ModuleInfoFilePrinter printer = new ModuleInfoFilePrinter();
            printer.setUnicodeEscape(unicodeEscape);
            String entryPath = this.entry.getPath();
            assert (entryPath.endsWith(".class"));
            String entryInternalName = entryPath.substring(0, entryPath.length() - 6);
            DECOMPILER.decompile(loader, printer, entryInternalName);
        }
        catch (Throwable t) {
            assert (ExceptionUtil.printStackTrace(t));
            this.setText("// INTERNAL ERROR //");
        }
    }

    @Override
    public String getSyntaxStyle() {
        return SYNTAX_STYLE_JAVA_MODULE;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkPage.HyperlinkData hyperlinkData) {
        block13: {
            TypePage.HyperlinkReferenceData hyperlinkReferenceData = (TypePage.HyperlinkReferenceData)hyperlinkData;
            if (hyperlinkReferenceData.reference.enabled) {
                try {
                    List<Container.Entry> entries;
                    String fragment;
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    ModuleInfoReferenceData moduleInfoReferenceData = (ModuleInfoReferenceData)hyperlinkReferenceData.reference;
                    switch (moduleInfoReferenceData.type) {
                        case 1: {
                            fragment = moduleInfoReferenceData.typeName;
                            entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, fragment);
                            break;
                        }
                        case 5: {
                            entries = IndexesUtil.find(this.collectionOfFutureIndexes, "packageDeclarations", moduleInfoReferenceData.typeName);
                            fragment = null;
                            break;
                        }
                        default: {
                            entries = IndexesUtil.find(this.collectionOfFutureIndexes, "javaModuleDeclarations", moduleInfoReferenceData.name);
                            fragment = moduleInfoReferenceData.typeName;
                        }
                    }
                    if (entries.contains(this.entry)) {
                        this.api.openURI(uri);
                    } else {
                        String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                        for (Container.Entry entry : entries) {
                            if (!entry.getUri().toString().startsWith(rootUri)) continue;
                            sameContainerEntries.add(entry);
                        }
                        if (sameContainerEntries.size() > 0) {
                            this.api.openURI(x, y, sameContainerEntries, null, fragment);
                        } else if (entries.size() > 0) {
                            this.api.openURI(x, y, entries, null, fragment);
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block13;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean openUri(URI uri) {
        ArrayList<DocumentRange> ranges = new ArrayList<DocumentRange>();
        String fragment = uri.getFragment();
        String query = uri.getQuery();
        Marker.clearMarkAllHighlights(this.textArea);
        if (fragment != null && this.declarations.size() == 1) {
            TypePage.DeclarationData declaration = (TypePage.DeclarationData)this.declarations.entrySet().iterator().next().getValue();
            if (fragment.equals(declaration.typeName)) {
                ranges.add(new DocumentRange(declaration.startPosition, declaration.endPosition));
            }
        }
        if (query != null) {
            Map<String, String> parameters = this.parseQuery(query);
            String highlightFlags = parameters.get("highlightFlags");
            String highlightPattern = parameters.get("highlightPattern");
            if (highlightFlags != null && highlightPattern != null) {
                boolean M;
                String regexp = ModuleInfoFilePage.createRegExp(highlightPattern);
                Pattern pattern = Pattern.compile(regexp + ".*");
                boolean t = highlightFlags.indexOf(116) != -1;
                boolean bl = M = highlightFlags.indexOf(77) != -1;
                if (highlightFlags.indexOf(100) != -1) {
                    for (Map.Entry entry : this.declarations.entrySet()) {
                        TypePage.DeclarationData declaration = (TypePage.DeclarationData)entry.getValue();
                        if (!M) continue;
                        ModuleInfoFilePage.matchAndAddDocumentRange(pattern, declaration.name, declaration.startPosition, declaration.endPosition, ranges);
                    }
                }
                if (highlightFlags.indexOf(114) != -1) {
                    for (Map.Entry entry : this.hyperlinks.entrySet()) {
                        HyperlinkPage.HyperlinkData hyperlink = (HyperlinkPage.HyperlinkData)entry.getValue();
                        TypePage.ReferenceData reference = ((TypePage.HyperlinkReferenceData)hyperlink).reference;
                        ModuleInfoReferenceData moduleInfoReferenceData = (ModuleInfoReferenceData)reference;
                        if (t && moduleInfoReferenceData.type == 1) {
                            ModuleInfoFilePage.matchAndAddDocumentRange(pattern, ModuleInfoFilePage.getMostInnerTypeName(moduleInfoReferenceData.typeName), hyperlink.startPosition, hyperlink.endPosition, ranges);
                        }
                        if (!M || moduleInfoReferenceData.type != 6) continue;
                        ModuleInfoFilePage.matchAndAddDocumentRange(pattern, moduleInfoReferenceData.name, hyperlink.startPosition, hyperlink.endPosition, ranges);
                    }
                }
            }
        }
        if (ranges != null && !ranges.isEmpty()) {
            this.textArea.setMarkAllHighlightColor(SELECT_HIGHLIGHT_COLOR);
            Marker.markAll(this.textArea, ranges);
            ranges.sort(null);
            this.setCaretPositionAndCenter(ranges.get(0));
        }
        return true;
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (TypePage.ReferenceData reference : this.references) {
            boolean enabled;
            block9: {
                ModuleInfoReferenceData moduleInfoReferenceData = (ModuleInfoReferenceData)reference;
                enabled = false;
                try {
                    for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                        String key;
                        Map<String, Collection> index;
                        if (!futureIndexes.isDone()) continue;
                        switch (moduleInfoReferenceData.type) {
                            case 1: {
                                index = futureIndexes.get().getIndex("typeDeclarations");
                                key = reference.typeName;
                                break;
                            }
                            case 5: {
                                index = futureIndexes.get().getIndex("packageDeclarations");
                                key = reference.typeName;
                                break;
                            }
                            default: {
                                index = futureIndexes.get().getIndex("javaModuleDeclarations");
                                key = reference.name;
                            }
                        }
                        if (index == null || index.get(key) == null) continue;
                        enabled = true;
                        break;
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block9;
                    throw new AssertionError();
                }
            }
            if (reference.enabled == enabled) continue;
            reference.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    static {
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping(SYNTAX_STYLE_JAVA_MODULE, ModuleInfoTokenMaker.class.getName());
    }

    public static class ModuleInfoTokenMaker
    extends AbstractTokenMaker {
        @Override
        public TokenMap getWordsToHighlight() {
            TokenMap tokenMap = new TokenMap();
            tokenMap.put("exports", 6);
            tokenMap.put("module", 6);
            tokenMap.put("open", 6);
            tokenMap.put("opens", 6);
            tokenMap.put("provides", 6);
            tokenMap.put("requires", 6);
            tokenMap.put("to", 6);
            tokenMap.put("transitive", 6);
            tokenMap.put("uses", 6);
            tokenMap.put("with", 6);
            return tokenMap;
        }

        @Override
        public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
            int value;
            if (tokenType == 20 && (value = this.wordsToHighlight.get(segment, start, end)) != -1) {
                tokenType = value;
            }
            super.addToken(segment, start, end, tokenType, startOffset);
        }

        @Override
        public Token getTokenList(Segment text, int startTokenType, int startOffset) {
            this.resetTokenList();
            char[] array = text.array;
            int offset = text.offset;
            int end = offset + text.count;
            int newStartOffset = startOffset - offset;
            int currentTokenStart = offset;
            int currentTokenType = startTokenType;
            block4: for (int i = offset; i < end; ++i) {
                char c = array[i];
                switch (currentTokenType) {
                    case 0: {
                        currentTokenStart = i;
                        if (RSyntaxUtilities.isLetter(c) || c == '_') {
                            currentTokenType = 20;
                            continue block4;
                        }
                        currentTokenType = 21;
                        continue block4;
                    }
                    default: {
                        if (!RSyntaxUtilities.isLetter(c) && c != '_') continue block4;
                        this.addToken(text, currentTokenStart, i - 1, 21, newStartOffset + currentTokenStart);
                        currentTokenStart = i;
                        currentTokenType = 20;
                        continue block4;
                    }
                    case 20: {
                        if (RSyntaxUtilities.isLetterOrDigit(c) || c == '_' || c == '.') continue block4;
                        this.addToken(text, currentTokenStart, i - 1, 20, newStartOffset + currentTokenStart);
                        currentTokenStart = i;
                        currentTokenType = 21;
                    }
                }
            }
            if (currentTokenType == 0) {
                this.addNullToken();
            } else {
                this.addToken(text, currentTokenStart, end - 1, currentTokenType, newStartOffset + currentTokenStart);
                this.addNullToken();
            }
            return this.firstToken;
        }
    }

    public class ModuleInfoFilePrinter
    extends StringBuilderPrinter {
        protected HashMap<String, TypePage.ReferenceData> referencesCache = new HashMap();

        @Override
        public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        }

        @Override
        public void end() {
            ModuleInfoFilePage.this.setText(this.stringBuffer.toString());
            ModuleInfoFilePage.this.initLineNumbers();
        }

        @Override
        public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
            ModuleInfoFilePage.this.declarations.put(internalTypeName, new TypePage.DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, name, descriptor));
            super.printDeclaration(type, internalTypeName, name, descriptor);
        }

        @Override
        public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
            String key = type == 6 ? name : internalTypeName;
            TypePage.ReferenceData reference = this.referencesCache.get(key);
            if (reference == null) {
                reference = new ModuleInfoReferenceData(type, internalTypeName, name, descriptor, ownerInternalName);
                this.referencesCache.put(key, reference);
                ModuleInfoFilePage.this.references.add(reference);
            }
            ModuleInfoFilePage.this.addHyperlink(new TypePage.HyperlinkReferenceData(this.stringBuffer.length(), name.length(), reference));
            super.printReference(type, internalTypeName, name, descriptor, ownerInternalName);
        }
    }

    protected static class ModuleInfoReferenceData
    extends TypePage.ReferenceData {
        public int type;

        public ModuleInfoReferenceData(int type, String typeName, String name, String descriptor, String owner) {
            super(typeName, name, descriptor, owner);
            this.type = type;
        }
    }
}

