/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.xbs;

import com.projectlibre1.graphic.configuration.BarFormat;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.graphic.configuration.TexturedShape;
import com.projectlibre1.pm.graphic.model.cache.GraphicDependency;
import com.projectlibre1.pm.graphic.model.cache.GraphicNode;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.event.CompositeCacheEvent;
import com.projectlibre1.pm.graphic.network.NetworkParams;
import com.projectlibre1.pm.graphic.network.layout.AbstractNetworkLayout;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Closure;

public class XbsLayout
extends AbstractNetworkLayout {
    protected List dependencies = new ArrayList();
    protected TexturedShapeFinder texturedShapeFinder = new TexturedShapeFinder();

    public XbsLayout(NetworkParams networkParams) {
        super(networkParams);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setCache(NodeModelCache nodeModelCache) {
        super.setCache(nodeModelCache);
    }

    protected TexturedShape findShape(GraphicNode graphicNode) {
        this.texturedShapeFinder.initialize(graphicNode);
        this.barStyles.apply(graphicNode.getNode().getImpl(), this.texturedShapeFinder);
        return this.texturedShapeFinder.getShape();
    }

    private void setShape(GraphicNode graphicNode, Rectangle2D rectangle2D, double d, double d2) {
        TexturedShape texturedShape = this.findShape(graphicNode);
        if (texturedShape == null) {
            return;
        }
        GeneralPath generalPath = texturedShape.toGeneralPath(rectangle2D.getWidth(), rectangle2D.getHeight(), d - rectangle2D.getWidth() / 2.0, d2, null);
        graphicNode.setXbsShape(generalPath, d, d2);
        Rectangle.union(this.bounds, this.network.scale(generalPath.getBounds()), this.bounds);
    }

    protected int updateBounds(Point2D point2D, Rectangle2D rectangle2D) {
        double d = point2D.getX() + rectangle2D.getWidth() / 2.0;
        double d2 = point2D.getY() + rectangle2D.getHeight() / 2.0;
        GraphicNode graphicNode = null;
        int n = 0;
        ListIterator listIterator = this.cache.getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode2 = (GraphicNode)listIterator.next();
            if (graphicNode2.getLevel() > n) {
                n = graphicNode2.getLevel();
            }
            if (graphicNode != null && graphicNode2.getLevel() <= graphicNode.getLevel()) {
                this.setShape(graphicNode, rectangle2D, d, d2 + (double)(graphicNode.getLevel() - 1) * rectangle2D.getMaxY());
                d += rectangle2D.getMaxX();
            }
            graphicNode = graphicNode2;
        }
        if (graphicNode != null) {
            this.setShape(graphicNode, rectangle2D, d, d2 + (double)(graphicNode.getLevel() - 1) * rectangle2D.getMaxY());
        }
        return n;
    }

    protected void updateBounds(int n, Point2D point2D, Rectangle2D rectangle2D) {
        double d = point2D.getY() + rectangle2D.getHeight() / 2.0 + rectangle2D.getMaxY() * (double)(n - 1);
        ListIterator listIterator = this.cache.getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            if (graphicNode.getLevel() != n) continue;
            double d2 = -1.0;
            double d3 = -1.0;
            boolean bl = false;
            while (listIterator.hasNext()) {
                GraphicNode graphicNode2 = (GraphicNode)listIterator.next();
                if (graphicNode2.getLevel() <= n) {
                    listIterator.previous();
                    break;
                }
                if (graphicNode2.getLevel() != n + 1) continue;
                bl = true;
                Point2D point2D2 = graphicNode2.getXbsCenter();
                if (d2 == -1.0 || point2D2.getX() < d2) {
                    d2 = point2D2.getX();
                }
                if (d3 == -1.0 || point2D2.getX() > d3) {
                    d3 = point2D2.getX();
                }
                this.dependencies.add(new GraphicDependency(graphicNode, graphicNode2, null));
            }
            if (!bl) continue;
            this.setShape(graphicNode, rectangle2D, (d2 + d3) / 2.0, d);
        }
    }

    @Override
    public void updateBounds() {
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        Point2D.Double double_ = new Point2D.Double(graphicConfiguration.getTreeXOffset(), graphicConfiguration.getTreeYOffset());
        Rectangle2D.Double double_2 = new Rectangle2D.Double(graphicConfiguration.getTreeXOffset(), graphicConfiguration.getTreeYOffset(), graphicConfiguration.getTreeCellWidth(), graphicConfiguration.getTreeCellHeight());
        this.setEmpty();
        this.dependencies.clear();
        this.bounds.setFrame(0.0, 0.0, 0.0, 0.0);
        int n = this.updateBounds(double_, double_2);
        if (n == 0) {
            return;
        }
        for (int i = n - 1; i > 0; --i) {
            this.updateBounds(i, double_, double_2);
        }
        this.fireLayoutChanged();
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        if (!compositeCacheEvent.isNodeHierarchy()) {
            return;
        }
        this.updateBounds();
    }

    protected class TexturedShapeFinder
    implements Closure {
        protected BarFormat format;
        protected GraphicNode node;
        protected TexturedShape shape;

        protected TexturedShapeFinder() {
        }

        void initialize(GraphicNode graphicNode) {
            this.node = graphicNode;
            this.shape = null;
        }

        @Override
        public void execute(Object object) {
            this.format = (BarFormat)object;
            if (this.format.getMiddle() != null) {
                this.shape = this.format.getMiddle();
            }
        }

        public TexturedShape getShape() {
            return this.shape;
        }
    }
}

