/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.MutableTableModelEvent;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTableModel<E>
extends AbstractTableModel
implements ListEventListener<E> {
    protected TransformedList<E, E> swingThreadSource;
    protected EventList<E> source;
    private TableFormat<? super E> tableFormat;
    private final MutableTableModelEvent tableModelEvent = new MutableTableModelEvent(this);
    private boolean fireOneTableModelEventOnly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTableModel(EventList<E> source, TableFormat<? super E> tableFormat) {
        source.getReadWriteLock().readLock().lock();
        try {
            TransformedList<E, E> decorated = this.createSwingThreadProxyList(source);
            if (decorated != null && decorated != source) {
                this.swingThreadSource = decorated;
                this.source = this.swingThreadSource;
            } else {
                this.source = source;
            }
            this.tableFormat = tableFormat;
            this.source.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public EventTableModel(EventList<E> source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        this(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    protected TransformedList<E, E> createSwingThreadProxyList(EventList<E> source) {
        return GlazedListsSwing.isSwingThreadProxyList(source) ? null : GlazedListsSwing.swingThreadProxyList(source);
    }

    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(TableFormat<E> tableFormat) {
        this.tableFormat = tableFormat;
        this.tableModelEvent.setStructureChanged();
        this.fireTableChanged(this.tableModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getElementAt(int index) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object e = this.source.get(index);
            return e;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    private void fireOneTableModelEvent(ListEvent<E> listChanges) {
        listChanges.nextBlock();
        int startIndex = listChanges.getBlockStartIndex();
        int endIndex = listChanges.getBlockEndIndex();
        int changeType = listChanges.getType();
        this.tableModelEvent.setValues(startIndex, endIndex, changeType);
        if (listChanges.nextBlock()) {
            this.tableModelEvent.setAllDataChanged();
        }
        this.fireTableChanged(this.tableModelEvent);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        if (this.isFireOneTableModelEventOnly() && !listChanges.isReordering()) {
            this.fireOneTableModelEvent(listChanges);
        } else {
            while (listChanges.nextBlock()) {
                int startIndex = listChanges.getBlockStartIndex();
                int endIndex = listChanges.getBlockEndIndex();
                int changeType = listChanges.getType();
                this.tableModelEvent.setValues(startIndex, endIndex, changeType);
                this.fireTableChanged(this.tableModelEvent);
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            int n = this.source.size();
            return n;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(columnIndex);
        }
        return super.getColumnClass(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        this.source.getReadWriteLock().readLock().lock();
        try {
            Object object = this.tableFormat.getColumnValue(this.source.get(row), column);
            return object;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.tableFormat instanceof WritableTableFormat) {
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            this.source.getReadWriteLock().readLock().lock();
            try {
                Object toEdit = this.source.get(row);
                boolean bl = writableTableFormat.isEditable(toEdit, column);
                return bl;
            }
            finally {
                this.source.getReadWriteLock().readLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValueAt(Object editedValue, int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) throw new UnsupportedOperationException("Unexpected setValueAt() on read-only table");
        this.source.getReadWriteLock().writeLock().lock();
        try {
            boolean baseObjectHasNotMoved;
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object baseObject = this.source.get(row);
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, editedValue, column);
            if (updatedObject == null) return;
            boolean bl = baseObjectHasNotMoved = row < this.getRowCount() && this.source.get(row) == baseObject;
            if (!baseObjectHasNotMoved) return;
            this.source.set(row, updatedObject);
            return;
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean isFireOneTableModelEventOnly() {
        return this.fireOneTableModelEventOnly;
    }

    public void setFireOneTableModelEventOnly(boolean fireOneTableModelEventOnly) {
        this.fireOneTableModelEventOnly = fireOneTableModelEventOnly;
    }

    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.swingThreadSource != null) {
            this.swingThreadSource.dispose();
        }
        this.swingThreadSource = null;
        this.source = null;
    }
}

