/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.operation.buffer.BufferSubgraph;

class SubgraphDepthLocater {
    private Collection subgraphs;
    private LineSegment seg = new LineSegment();

    public SubgraphDepthLocater(List subgraphs) {
        this.subgraphs = subgraphs;
    }

    public int getDepth(Coordinate p) {
        List stabbedSegments = this.findStabbedSegments(p);
        if (stabbedSegments.size() == 0) {
            return 0;
        }
        DepthSegment ds = (DepthSegment)Collections.min(stabbedSegments);
        return ds.leftDepth;
    }

    private List findStabbedSegments(Coordinate stabbingRayLeftPt) {
        ArrayList stabbedSegments = new ArrayList();
        for (BufferSubgraph bsg : this.subgraphs) {
            Envelope env = bsg.getEnvelope();
            if (stabbingRayLeftPt.y < env.getMinY() || stabbingRayLeftPt.y > env.getMaxY()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, bsg.getDirectedEdges(), stabbedSegments);
        }
        return stabbedSegments;
    }

    private void findStabbedSegments(Coordinate stabbingRayLeftPt, List dirEdges, List stabbedSegments) {
        for (DirectedEdge de : dirEdges) {
            if (!de.isForward()) continue;
            this.findStabbedSegments(stabbingRayLeftPt, de, stabbedSegments);
        }
    }

    private void findStabbedSegments(Coordinate stabbingRayLeftPt, DirectedEdge dirEdge, List stabbedSegments) {
        Coordinate[] pts = dirEdge.getEdge().getCoordinates();
        for (int i = 0; i < pts.length - 1; ++i) {
            double maxx;
            this.seg.p0 = pts[i];
            this.seg.p1 = pts[i + 1];
            if (this.seg.p0.y > this.seg.p1.y) {
                this.seg.reverse();
            }
            if ((maxx = Math.max(this.seg.p0.x, this.seg.p1.x)) < stabbingRayLeftPt.x || this.seg.isHorizontal() || stabbingRayLeftPt.y < this.seg.p0.y || stabbingRayLeftPt.y > this.seg.p1.y || Orientation.index(this.seg.p0, this.seg.p1, stabbingRayLeftPt) == -1) continue;
            int depth = dirEdge.getDepth(1);
            if (!this.seg.p0.equals(pts[i])) {
                depth = dirEdge.getDepth(2);
            }
            DepthSegment ds = new DepthSegment(this.seg, depth);
            stabbedSegments.add(ds);
        }
    }

    static class DepthSegment
    implements Comparable {
        private LineSegment upwardSeg;
        private int leftDepth;

        public DepthSegment(LineSegment seg, int depth) {
            this.upwardSeg = new LineSegment(seg);
            this.leftDepth = depth;
        }

        public boolean isUpward() {
            return this.upwardSeg.p0.y <= this.upwardSeg.p1.y;
        }

        public int compareTo(Object obj) {
            DepthSegment other = (DepthSegment)obj;
            if (this.upwardSeg.minX() >= other.upwardSeg.maxX() || this.upwardSeg.maxX() <= other.upwardSeg.minX() || this.upwardSeg.minY() >= other.upwardSeg.maxY() || this.upwardSeg.maxY() <= other.upwardSeg.minY()) {
                return this.upwardSeg.compareTo(other.upwardSeg);
            }
            int orientIndex = this.upwardSeg.orientationIndex(other.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            orientIndex = -1 * other.upwardSeg.orientationIndex(this.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            return 0;
        }

        public int OLDcompareTo(Object obj) {
            DepthSegment other = (DepthSegment)obj;
            if (this.upwardSeg.minX() > other.upwardSeg.maxX()) {
                return 1;
            }
            if (this.upwardSeg.maxX() < other.upwardSeg.minX()) {
                return -1;
            }
            int orientIndex = this.upwardSeg.orientationIndex(other.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            orientIndex = -1 * other.upwardSeg.orientationIndex(this.upwardSeg);
            if (orientIndex != 0) {
                return orientIndex;
            }
            return this.upwardSeg.compareTo(other.upwardSeg);
        }

        public String toString() {
            return this.upwardSeg.toString();
        }
    }
}

