/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractOptionCheck;
import com.puppycrawl.tools.checkstyle.checks.LeftCurlyOption;

public class LeftCurlyCheck
extends AbstractOptionCheck {
    private static final int DEFAULT_MAX_LINE_LENGTH = 80;
    private int mMaxLineLength = 80;

    public LeftCurlyCheck() {
        super(LeftCurlyOption.EOL);
    }

    public void setMaxLineLength(int aMaxLineLength) {
        this.mMaxLineLength = aMaxLineLength;
    }

    public int[] getDefaultTokens() {
        return new int[]{15, 14, 8, 9, 85, 95, 96, 97, 67, 90, 86, 83, 92, 84};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST brace;
        DetailAST startToken;
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                startToken = aAST;
                brace = aAST.findFirstToken(7);
                break;
            }
            case 14: 
            case 15: {
                startToken = (DetailAST)aAST.getFirstChild().getNextSibling();
                brace = (DetailAST)aAST.getLastChild().getFirstChild();
                break;
            }
            case 67: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 95: 
            case 96: 
            case 97: {
                startToken = aAST;
                brace = aAST.findFirstToken(7);
                break;
            }
            case 92: {
                startToken = aAST;
                DetailAST candidate = (DetailAST)aAST.getFirstChild();
                brace = candidate.getType() == 7 ? candidate : null;
                break;
            }
            case 90: {
                startToken = aAST;
                brace = aAST.findFirstToken(72);
                break;
            }
            default: {
                startToken = null;
                brace = null;
            }
        }
        if (brace != null && startToken != null) {
            this.verifyBrace(brace, startToken);
        }
    }

    private void verifyBrace(DetailAST aBrace, DetailAST aStartToken) {
        int prevLineLen;
        String braceLine = this.getLines()[aBrace.getLineNo() - 1];
        int n = prevLineLen = aBrace.getLineNo() == 1 ? this.mMaxLineLength : Utils.lengthMinusTrailingWhitespace(this.getLines()[aBrace.getLineNo() - 2]);
        if (braceLine.length() <= aBrace.getColumnNo() + 1 || braceLine.charAt(aBrace.getColumnNo() + 1) != '}') {
            if (this.getAbstractOption() == LeftCurlyOption.NL) {
                if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", (Object)"{");
                }
            } else if (this.getAbstractOption() == LeftCurlyOption.EOL) {
                if (Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine) && prevLineLen + 2 <= this.mMaxLineLength) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.previous", (Object)"{");
                }
            } else if (this.getAbstractOption() == LeftCurlyOption.NLOW && aStartToken.getLineNo() != aBrace.getLineNo()) {
                if (aStartToken.getLineNo() + 1 == aBrace.getLineNo()) {
                    if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                        this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", (Object)"{");
                    } else if (prevLineLen + 2 <= this.mMaxLineLength) {
                        this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.previous", (Object)"{");
                    }
                } else if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.log(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", (Object)"{");
                }
            }
        }
    }
}

