use shared::basetsd::ULONG64;
use shared::guiddef::GUID;
use shared::minwindef::{DWORD, UCHAR, ULONG, USHORT};
use shared::ntdef::{BOOLEAN, HANDLE, LARGE_INTEGER, LONG, NTSTATUS, PWCHAR, WCHAR};
use shared::usb::USBD_STATUS;
use shared::usbiodef::{
    FILE_DEVICE_USB, HCD_DIAGNOSTIC_MODE_OFF, HCD_DIAGNOSTIC_MODE_ON, HCD_DISABLE_PORT,
    HCD_ENABLE_PORT, HCD_GET_DRIVERKEY_NAME, HCD_GET_ROOT_HUB_NAME, HCD_GET_STATS_1,
    HCD_GET_STATS_2, USB_CYCLE_PORT, USB_DIAG_IGNORE_HUBS_OFF, USB_DIAG_IGNORE_HUBS_ON,
    USB_ENABLE_PORT, USB_FAIL_GET_STATUS, USB_GET_BUSGUID_INFO, USB_GET_BUS_INFO,
    USB_GET_CONTROLLER_NAME, USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION,
    USB_GET_DEVICE_CHARACTERISTICS, USB_GET_DEVICE_HANDLE, USB_GET_DEVICE_HANDLE_EX,
    USB_GET_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC, USB_GET_HUB_CAPABILITIES,
    USB_GET_HUB_CAPABILITIES_EX, USB_GET_HUB_CONFIG_INFO, USB_GET_HUB_COUNT,
    USB_GET_HUB_INFORMATION_EX, USB_GET_HUB_NAME, USB_GET_NODE_CONNECTION_ATTRIBUTES,
    USB_GET_NODE_CONNECTION_DRIVERKEY_NAME, USB_GET_NODE_CONNECTION_INFORMATION,
    USB_GET_NODE_CONNECTION_INFORMATION_EX, USB_GET_NODE_CONNECTION_INFORMATION_EX_V2,
    USB_GET_NODE_CONNECTION_NAME, USB_GET_NODE_INFORMATION, USB_GET_PARENT_HUB_INFO,
    USB_GET_PORT_CONNECTOR_PROPERTIES, USB_GET_PORT_STATUS, USB_GET_ROOTHUB_PDO,
    USB_GET_TOPOLOGY_ADDRESS, USB_GET_TRANSPORT_CHARACTERISTICS, USB_GET_TT_DEVICE_HANDLE,
    USB_HUB_CYCLE_PORT, USB_IDLE_NOTIFICATION, USB_IDLE_NOTIFICATION_EX,
    USB_NOTIFY_ON_TRANSPORT_CHARACTERISTICS_CHANGE, USB_RECORD_FAILURE,
    USB_REGISTER_COMPOSITE_DEVICE, USB_REGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE,
    USB_REQUEST_REMOTE_WAKE_NOTIFICATION, USB_REQ_GLOBAL_RESUME, USB_REQ_GLOBAL_SUSPEND,
    USB_RESET_HUB, USB_RESET_PORT, USB_START_TRACKING_FOR_TIME_SYNC,
    USB_STOP_TRACKING_FOR_TIME_SYNC, USB_SUBMIT_URB, USB_UNREGISTER_COMPOSITE_DEVICE,
    USB_UNREGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE,
};
use shared::usbspec::{
    USB_30_HUB_DESCRIPTOR, USB_CONFIGURATION_DESCRIPTOR, USB_DEVICE_DESCRIPTOR, USB_DEVICE_SPEED,
    USB_ENDPOINT_DESCRIPTOR, USB_HUB_DESCRIPTOR,
};
use um::winioctl::{FILE_ANY_ACCESS, FILE_DEVICE_USBEX, METHOD_BUFFERED, METHOD_NEITHER};
pub const IOCTL_INTERNAL_USB_SUBMIT_URB: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_SUBMIT_URB, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_RESET_PORT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_RESET_PORT, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_ROOTHUB_PDO: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_ROOTHUB_PDO, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const USBD_PORT_ENABLED: DWORD = 0x00000001;
pub const USBD_PORT_CONNECTED: DWORD = 0x00000002;
pub const IOCTL_INTERNAL_USB_GET_PORT_STATUS: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_PORT_STATUS, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_ENABLE_PORT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_ENABLE_PORT, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_HUB_COUNT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_HUB_COUNT, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_CYCLE_PORT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_CYCLE_PORT, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_HUB_NAME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_HUB_NAME, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_BUS_INFO: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_BUS_INFO, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_CONTROLLER_NAME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_CONTROLLER_NAME, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_BUSGUID_INFO: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_BUSGUID_INFO, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_PARENT_HUB_INFO: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_PARENT_HUB_INFO, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_SUBMIT_IDLE_NOTIFICATION: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_IDLE_NOTIFICATION, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_DEVICE_HANDLE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_DEVICE_HANDLE, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_NOTIFY_IDLE_READY: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_IDLE_NOTIFICATION_EX, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_REQ_GLOBAL_SUSPEND: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_REQ_GLOBAL_SUSPEND, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_REQ_GLOBAL_RESUME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_REQ_GLOBAL_RESUME, METHOD_NEITHER, FILE_ANY_ACCESS);
STRUCT!{struct USB_START_FAILDATA {
    LengthInBytes: ULONG,
    NtStatus: NTSTATUS,
    UsbdStatus: USBD_STATUS,
    ConnectStatus: ULONG,
    DriverData: [UCHAR; 4],
}}
pub type PUSB_START_FAILDATA = *mut USB_START_FAILDATA;
pub const IOCTL_INTERNAL_USB_RECORD_FAILURE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_RECORD_FAILURE, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_DEVICE_HANDLE_EX: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_DEVICE_HANDLE_EX, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_TT_DEVICE_HANDLE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_TT_DEVICE_HANDLE, METHOD_NEITHER, FILE_ANY_ACCESS);
STRUCT!{struct USB_TOPOLOGY_ADDRESS {
    PciBusNumber: ULONG,
    PciDeviceNumber: ULONG,
    PciFunctionNumber: ULONG,
    Reserved: ULONG,
    RootHubPortNumber: USHORT,
    HubPortNumber: [USHORT; 5],
    Reserved2: USHORT,
}}
pub type PUSB_TOPOLOGY_ADDRESS = *mut USB_TOPOLOGY_ADDRESS;
pub const IOCTL_INTERNAL_USB_GET_TOPOLOGY_ADDRESS: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_TOPOLOGY_ADDRESS, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_GET_DEVICE_CONFIG_INFO: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_HUB_CONFIG_INFO, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_REGISTER_COMPOSITE_DEVICE: DWORD
    = CTL_CODE!(FILE_DEVICE_USBEX, USB_REGISTER_COMPOSITE_DEVICE, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_UNREGISTER_COMPOSITE_DEVICE: DWORD
    = CTL_CODE!(FILE_DEVICE_USBEX, USB_UNREGISTER_COMPOSITE_DEVICE, METHOD_NEITHER,
        FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_REQUEST_REMOTE_WAKE_NOTIFICATION: DWORD
    = CTL_CODE!(FILE_DEVICE_USBEX, USB_REQUEST_REMOTE_WAKE_NOTIFICATION, METHOD_NEITHER,
        FILE_ANY_ACCESS);
pub const IOCTL_INTERNAL_USB_FAIL_GET_STATUS_FROM_DEVICE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_FAIL_GET_STATUS, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const IOCTL_USB_HCD_GET_STATS_1: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_GET_STATS_1, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_HCD_GET_STATS_2: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_GET_STATS_2, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_HCD_DISABLE_PORT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_DISABLE_PORT, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_HCD_ENABLE_PORT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_ENABLE_PORT, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_DIAGNOSTIC_MODE_ON: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_DIAGNOSTIC_MODE_ON, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_DIAGNOSTIC_MODE_OFF: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_DIAGNOSTIC_MODE_OFF, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_ROOT_HUB_NAME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_GET_ROOT_HUB_NAME, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_GET_HCD_DRIVERKEY_NAME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, HCD_GET_DRIVERKEY_NAME, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_INFORMATION: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_INFORMATION, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_CONNECTION_INFORMATION: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_CONNECTION_INFORMATION, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_CONNECTION_NAME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_CONNECTION_NAME, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_DIAG_IGNORE_HUBS_ON: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_DIAG_IGNORE_HUBS_ON, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_DIAG_IGNORE_HUBS_OFF: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_DIAG_IGNORE_HUBS_OFF, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_CONNECTION_DRIVERKEY_NAME: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_CONNECTION_DRIVERKEY_NAME, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_HUB_CAPABILITIES: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_HUB_CAPABILITIES, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_HUB_CYCLE_PORT: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_HUB_CYCLE_PORT, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_CONNECTION_ATTRIBUTES: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_CONNECTION_ATTRIBUTES, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_CONNECTION_INFORMATION_EX: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_CONNECTION_INFORMATION_EX, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_RESET_HUB: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_RESET_HUB, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_HUB_CAPABILITIES_EX: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_HUB_CAPABILITIES_EX, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_HUB_INFORMATION_EX: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_HUB_INFORMATION_EX, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_PORT_CONNECTOR_PROPERTIES: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_PORT_CONNECTOR_PROPERTIES, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_NODE_CONNECTION_INFORMATION_EX_V2: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_NODE_CONNECTION_INFORMATION_EX_V2, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_TRANSPORT_CHARACTERISTICS: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_TRANSPORT_CHARACTERISTICS, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_REGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_REGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE,
        METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_NOTIFY_ON_TRANSPORT_CHARACTERISTICS_CHANGE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_NOTIFY_ON_TRANSPORT_CHARACTERISTICS_CHANGE, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_UNREGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_UNREGISTER_FOR_TRANSPORT_CHARACTERISTICS_CHANGE,
        METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const IOCTL_USB_START_TRACKING_FOR_TIME_SYNC: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_START_TRACKING_FOR_TIME_SYNC, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_STOP_TRACKING_FOR_TIME_SYNC: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_STOP_TRACKING_FOR_TIME_SYNC, METHOD_BUFFERED,
        FILE_ANY_ACCESS);
pub const IOCTL_USB_GET_DEVICE_CHARACTERISTICS: DWORD
    = CTL_CODE!(FILE_DEVICE_USB, USB_GET_DEVICE_CHARACTERISTICS, METHOD_BUFFERED, FILE_ANY_ACCESS);
ENUM!{enum USB_HUB_NODE {
    UsbHub,
    UsbMIParent,
}}
STRUCT!{#[repr(packed)] struct USB_HUB_INFORMATION {
    HubDescriptor: USB_HUB_DESCRIPTOR,
    HubIsBusPowered: BOOLEAN,
}}
pub type PUSB_HUB_INFORMATION = *mut USB_HUB_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_MI_PARENT_INFORMATION {
    NumberOfInterfaces: ULONG,
}}
pub type PUSB_MI_PARENT_INFORMATION = *mut USB_MI_PARENT_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_NODE_INFORMATION {
    NodeType: USB_HUB_NODE,
    u: USB_NODE_INFORMATION_u,
}}
UNION!{union USB_NODE_INFORMATION_u {
    [u8; 72],
    HubInformation HubInformation_mut: USB_HUB_INFORMATION,
    MiParentInformation MiParentInformation_mut: USB_MI_PARENT_INFORMATION,
}}
pub type PUSB_NODE_INFORMATION = *mut USB_NODE_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_PIPE_INFO {
    EndpointDescriptor: USB_ENDPOINT_DESCRIPTOR,
    ScheduleOffset: ULONG,
}}
pub type PUSB_PIPE_INFO = *mut USB_PIPE_INFO;
ENUM!{enum USB_CONNECTION_STATUS {
    NoDeviceConnected,
    DeviceConnected,
    DeviceFailedEnumeration,
    DeviceGeneralFailure,
    DeviceCausedOvercurrent,
    DeviceNotEnoughPower,
    DeviceNotEnoughBandwidth,
    DeviceHubNestedTooDeeply,
    DeviceInLegacyHub,
    DeviceEnumerating,
    DeviceReset,
}}
pub type PUSB_CONNECTION_STATUS = *mut USB_CONNECTION_STATUS;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_INFORMATION {
    ConnectionIndex: ULONG,
    DeviceDescriptor: USB_DEVICE_DESCRIPTOR,
    CurrentConfigurationValue: UCHAR,
    LowSpeed: BOOLEAN,
    DeviceIsHub: BOOLEAN,
    DeviceAddress: USHORT,
    NumberOfOpenPipes: ULONG,
    ConnectionStatus: USB_CONNECTION_STATUS,
    PipeList: [USB_PIPE_INFO; 0],
}}
pub type PUSB_NODE_CONNECTION_INFORMATION = *mut USB_NODE_CONNECTION_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_DRIVERKEY_NAME {
    ConnectionIndex: ULONG,
    ActualLength: ULONG,
    DriverKeyName: [WCHAR; 1],
}}
pub type PUSB_NODE_CONNECTION_DRIVERKEY_NAME = *mut USB_NODE_CONNECTION_DRIVERKEY_NAME;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_NAME {
    ConnectionIndex: ULONG,
    ActualLength: ULONG,
    NodeName: [WCHAR; 1],
}}
pub type PUSB_NODE_CONNECTION_NAME = *mut USB_NODE_CONNECTION_NAME;
STRUCT!{#[repr(packed)] struct USB_HUB_NAME {
    ActualLength: ULONG,
    HubName: [WCHAR; 1],
}}
pub type PUSB_HUB_NAME = *mut USB_HUB_NAME;
STRUCT!{#[repr(packed)] struct USB_ROOT_HUB_NAME {
    ActualLength: ULONG,
    RootHubName: [WCHAR; 1],
}}
pub type PUSB_ROOT_HUB_NAME = *mut USB_ROOT_HUB_NAME;
STRUCT!{#[repr(packed)] struct USB_HCD_DRIVERKEY_NAME {
    ActualLength: ULONG,
    DriverKeyName: [WCHAR; 1],
}}
pub type PUSB_HCD_DRIVERKEY_NAME = *mut USB_HCD_DRIVERKEY_NAME;
STRUCT!{#[repr(packed)] struct USB_DESCRIPTOR_REQUEST {
    ConnectionIndex: ULONG,
    SetupPacket: USB_DESCRIPTOR_REQUEST_SetupPacket,
    Data: [UCHAR; 0],
}}
STRUCT!{#[repr(packed)] struct USB_DESCRIPTOR_REQUEST_SetupPacket {
    bmRequest: UCHAR,
    bRequest: UCHAR,
    wValue: USHORT,
    wIndex: USHORT,
    wLength: USHORT,
}}
pub type PUSB_DESCRIPTOR_REQUEST = *mut USB_DESCRIPTOR_REQUEST;
STRUCT!{#[repr(packed)] struct USB_HUB_CAPABILITIES {
    bitfield: ULONG,
}}
BITFIELD!{USB_HUB_CAPABILITIES bitfield: ULONG [
    HubIs2xCapable set_HubIs2xCapable[0..1],
]}
pub type PUSB_HUB_CAPABILITIES = *mut USB_HUB_CAPABILITIES;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_ATTRIBUTES {
    ConnectionIndex: ULONG,
    ConnectionStatus: USB_CONNECTION_STATUS,
    PortAttributes: ULONG,
}}
pub type PUSB_NODE_CONNECTION_ATTRIBUTES = *mut USB_NODE_CONNECTION_ATTRIBUTES;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_INFORMATION_EX {
    ConnectionIndex: ULONG,
    DeviceDescriptor: USB_DEVICE_DESCRIPTOR,
    CurrentConfigurationValue: UCHAR,
    Speed: UCHAR,
    DeviceIsHub: BOOLEAN,
    DeviceAddress: USHORT,
    NumberOfOpenPipes: ULONG,
    ConnectionStatus: USB_CONNECTION_STATUS,
    PipeList: [USB_PIPE_INFO; 0],
}}
pub type PUSB_NODE_CONNECTION_INFORMATION_EX = *mut USB_NODE_CONNECTION_INFORMATION_EX;
STRUCT!{#[repr(packed)] struct USB_HUB_CAP_FLAGS {
    ul: ULONG,
}}
BITFIELD!{USB_HUB_CAP_FLAGS ul: ULONG [
    HubIsHighSpeedCapable set_HubIsHighSpeedCapable[0..1],
    HubIsHighSpeed set_HubIsHighSpeed[1..2],
    HubIsMultiTtCapable set_HubIsMultiTtCapable[2..3],
    HubIsMultiTt set_HubIsMultiTt[3..4],
    HubIsRoot set_HubIsRoot[4..5],
    HubIsArmedWakeOnConnect set_HubIsArmedWakeOnConnect[5..6],
    HubIsBusPowered set_HubIsBusPowered[6..7],
    ReservedMBZ set_ReservedMBZ[7..32],
]}
pub type PUSB_HUB_CAP_FLAGS = *mut USB_HUB_CAP_FLAGS;
STRUCT!{#[repr(packed)] struct USB_HUB_CAPABILITIES_EX {
    CapabilityFlags: USB_HUB_CAP_FLAGS,
}}
pub type PUSB_HUB_CAPABILITIES_EX = *mut USB_HUB_CAPABILITIES_EX;
STRUCT!{#[repr(packed)] struct USB_CYCLE_PORT_PARAMS {
    ConnectionIndex: ULONG,
    StatusReturned: ULONG,
}}
pub type PUSB_CYCLE_PORT_PARAMS = *mut USB_CYCLE_PORT_PARAMS;
STRUCT!{#[repr(packed)] struct USB_ID_STRING {
    LanguageId: USHORT,
    Pad: USHORT,
    LengthInBytes: ULONG,
    Buffer: PWCHAR,
}}
pub type PUSB_ID_STRING = *mut USB_ID_STRING;
STRUCT!{#[repr(packed)] struct USB_HUB_DEVICE_UXD_SETTINGS {
    Version: ULONG,
    PnpGuid: GUID,
    OwnerGuid: GUID,
    DeleteOnShutdown: ULONG,
    DeleteOnReload: ULONG,
    DeleteOnDisconnect: ULONG,
    Reserved: [ULONG; 5],
}}
pub type PUSB_HUB_DEVICE_UXD_SETTINGS = *mut USB_HUB_DEVICE_UXD_SETTINGS;
STRUCT!{#[repr(packed)] struct HUB_DEVICE_CONFIG_INFO {
    Version: ULONG,
    Length: ULONG,
    HubFlags: USB_HUB_CAP_FLAGS,
    HardwareIds: USB_ID_STRING,
    CompatibleIds: USB_ID_STRING,
    DeviceDescription: USB_ID_STRING,
    Reserved: [ULONG; 19],
    UxdSettings: USB_HUB_DEVICE_UXD_SETTINGS,
}}
pub type PHUB_DEVICE_CONFIG_INFO = *mut HUB_DEVICE_CONFIG_INFO;
STRUCT!{#[repr(packed)] struct HCD_STAT_COUNTERS {
    BytesTransferred: ULONG,
    IsoMissedCount: USHORT,
    DataOverrunErrorCount: USHORT,
    CrcErrorCount: USHORT,
    ScheduleOverrunCount: USHORT,
    TimeoutErrorCount: USHORT,
    InternalHcErrorCount: USHORT,
    BufferOverrunErrorCount: USHORT,
    SWErrorCount: USHORT,
    StallPidCount: USHORT,
    PortDisableCount: USHORT,
}}
pub type PHCD_STAT_COUNTERS = *mut HCD_STAT_COUNTERS;
STRUCT!{#[repr(packed)] struct HCD_ISO_STAT_COUNTERS {
    LateUrbs: USHORT,
    DoubleBufferedPackets: USHORT,
    TransfersCF_5ms: USHORT,
    TransfersCF_2ms: USHORT,
    TransfersCF_1ms: USHORT,
    MaxInterruptLatency: USHORT,
    BadStartFrame: USHORT,
    StaleUrbs: USHORT,
    IsoPacketNotAccesed: USHORT,
    IsoPacketHWError: USHORT,
    SmallestUrbPacketCount: USHORT,
    LargestUrbPacketCount: USHORT,
    IsoCRC_Error: USHORT,
    IsoOVERRUN_Error: USHORT,
    IsoINTERNAL_Error: USHORT,
    IsoUNKNOWN_Error: USHORT,
    IsoBytesTransferred: ULONG,
    LateMissedCount: USHORT,
    HWIsoMissedCount: USHORT,
    Reserved7: [ULONG; 8],
}}
pub type PHCD_ISO_STAT_COUNTERS = *mut HCD_ISO_STAT_COUNTERS;
STRUCT!{#[repr(packed)] struct HCD_STAT_INFORMATION_1 {
    Reserved1: ULONG,
    Reserved2: ULONG,
    ResetCounters: ULONG,
    TimeRead: LARGE_INTEGER,
    Counters: HCD_STAT_COUNTERS,
}}
pub type PHCD_STAT_INFORMATION_1 = *mut HCD_STAT_INFORMATION_1;
STRUCT!{#[repr(packed)] struct HCD_STAT_INFORMATION_2 {
    Reserved1: ULONG,
    Reserved2: ULONG,
    ResetCounters: ULONG,
    TimeRead: LARGE_INTEGER,
    LockedMemoryUsed: LONG,
    Counters: HCD_STAT_COUNTERS,
    IsoCounters: HCD_ISO_STAT_COUNTERS,
}}
pub type PHCD_STAT_INFORMATION_2 = *mut HCD_STAT_INFORMATION_2;
pub const WMI_USB_DRIVER_INFORMATION: ULONG = 0;
pub const WMI_USB_DRIVER_NOTIFICATION: ULONG = 1;
pub const WMI_USB_POWER_DEVICE_ENABLE: ULONG = 2;
pub const WMI_USB_HUB_NODE_INFORMATION: ULONG = 4;
pub const WMI_USB_PERFORMANCE_INFORMATION: ULONG = 1;
pub const WMI_USB_DEVICE_NODE_INFORMATION: ULONG = 2;
ENUM!{enum USB_NOTIFICATION_TYPE {
    EnumerationFailure = 0,
    InsufficentBandwidth,
    InsufficentPower,
    OverCurrent,
    ResetOvercurrent,
    AcquireBusInfo,
    AcquireHubName,
    AcquireControllerName,
    HubOvercurrent,
    HubPowerChange,
    HubNestedTooDeeply,
    ModernDeviceInLegacyHub,
}}
STRUCT!{#[repr(packed)] struct USB_NOTIFICATION {
    NotificationType: USB_NOTIFICATION_TYPE,
}}
pub type PUSB_NOTIFICATION = *mut USB_NOTIFICATION;
STRUCT!{#[repr(packed)] struct USB_CONNECTION_NOTIFICATION {
    NotificationType: USB_NOTIFICATION_TYPE,
    ConnectionNumber: ULONG,
    RequestedBandwidth: ULONG,
    EnumerationFailReason: ULONG,
    PowerRequested: ULONG,
    HubNameLength: ULONG,
}}
pub type PUSB_CONNECTION_NOTIFICATION = *mut USB_CONNECTION_NOTIFICATION;
STRUCT!{#[repr(packed)] struct USB_BUS_NOTIFICATION {
    NotificationType: USB_NOTIFICATION_TYPE,
    TotalBandwidth: ULONG,
    ConsumedBandwidth: ULONG,
    ControllerNameLength: ULONG,
}}
pub type PUSB_BUS_NOTIFICATION = *mut USB_BUS_NOTIFICATION;
STRUCT!{#[repr(packed)] struct USB_ACQUIRE_INFO {
    NotificationType: USB_NOTIFICATION_TYPE,
    TotalSize: ULONG,
    Buffer: [WCHAR; 1],
}}
pub type PUSB_ACQUIRE_INFO = *mut USB_ACQUIRE_INFO;
ENUM!{enum USB_WMI_DEVICE_NODE_TYPE {
    UsbDevice,
    HubDevice,
    CompositeDevice,
    UsbController,
}}
pub type PUSB_WMI_DEVICE_NODE_TYPE = *mut USB_WMI_DEVICE_NODE_TYPE;
STRUCT!{#[repr(packed)] struct USB_DEVICE_STATE {
    bitfield: ULONG,
}}
BITFIELD!{USB_DEVICE_STATE bitfield: ULONG [
    DeviceConnected set_DeviceConnected[0..1],
    DeviceStarted set_DeviceStarted[1..2],
]}
pub type PUSB_DEVICE_STATE = *mut USB_DEVICE_STATE;
STRUCT!{#[repr(packed)] struct USB_HUB_PORT_INFORMATION {
    DeviceState: USB_DEVICE_STATE,
    PortNumber: USHORT,
    DeviceAddress: USHORT,
    ConnectionIndex: ULONG,
    ConnectionStatus: USB_CONNECTION_STATUS,
}}
pub type PUSB_HUB_PORT_INFORMATION = *mut USB_HUB_PORT_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_HUB_DEVICE_INFO {
    HubDescriptor: USB_HUB_DESCRIPTOR,
    HubNumber: ULONG,
    DeviceAddress: USHORT,
    HubIsSelfPowered: BOOLEAN,
    HubIsRootHub: BOOLEAN,
    HubCapabilities: USB_HUB_CAPABILITIES,
    NumberOfHubPorts: ULONG,
    PortInfo: [USB_HUB_PORT_INFORMATION; 1],
}}
pub type PUSB_HUB_DEVICE_INFO = *mut USB_HUB_DEVICE_INFO;
STRUCT!{#[repr(packed)] struct USB_COMPOSITE_FUNCTION_INFO {
    FunctionNumber: UCHAR,
    BaseInterfaceNumber: UCHAR,
    NumberOfInterfaces: UCHAR,
    FunctionIsIdle: BOOLEAN,
}}
pub type PUSB_COMPOSITE_FUNCTION_INFO = *mut USB_COMPOSITE_FUNCTION_INFO;
STRUCT!{#[repr(packed)] struct USB_COMPOSITE_DEVICE_INFO {
    DeviceDescriptor: USB_DEVICE_DESCRIPTOR,
    CurrentConfigDescriptor: USB_CONFIGURATION_DESCRIPTOR,
    CurrentConfigurationValue: UCHAR,
    NumberOfFunctions: UCHAR,
    FunctionInfo: [USB_COMPOSITE_FUNCTION_INFO; 1],
}}
pub type PUSB_COMPOSITE_DEVICE_INFO = *mut USB_COMPOSITE_DEVICE_INFO;
STRUCT!{#[repr(packed)] struct USB_CONTROLLER_DEVICE_INFO {
    PciVendorId: ULONG,
    PciDeviceId: ULONG,
    PciRevision: ULONG,
    NumberOfRootPorts: ULONG,
    HcFeatureFlags: ULONG,
}}
pub type PUSB_CONTROLLER_DEVICE_INFO = *mut USB_CONTROLLER_DEVICE_INFO;
STRUCT!{#[repr(packed)] struct USB_DEVICE_INFO {
    DeviceState: USB_DEVICE_STATE,
    PortNumber: USHORT,
    DeviceDescriptor: USB_DEVICE_DESCRIPTOR,
    CurrentConfigurationValue: UCHAR,
    Speed: USB_DEVICE_SPEED,
    DeviceAddress: USHORT,
    ConnectionIndex: ULONG,
    ConnectionStatus: USB_CONNECTION_STATUS,
    PnpHardwareId: [WCHAR; 128],
    PnpCompatibleId: [WCHAR; 128],
    SerialNumberId: [WCHAR; 128],
    PnpDeviceDescription: [WCHAR; 128],
    NumberOfOpenPipes: ULONG,
    PipeList: [USB_PIPE_INFO; 1],
}}
pub type PUSB_DEVICE_INFO = *mut USB_DEVICE_INFO;
STRUCT!{#[repr(packed)] struct USB_DEVICE_NODE_INFO {
    Sig: ULONG,
    LengthInBytes: ULONG,
    DeviceDescription: [WCHAR; 40],
    NodeType: USB_WMI_DEVICE_NODE_TYPE,
    BusAddress: USB_TOPOLOGY_ADDRESS,
    u: USB_DEVICE_NODE_INFO_u,
}}
UNION!{union USB_DEVICE_NODE_INFO_u {
    [u8; 1078],
    UsbDeviceInfo UsbDeviceInfo_mut: USB_DEVICE_INFO,
    HubDeviceInfo HubDeviceInfo_mut: USB_HUB_DEVICE_INFO,
    CompositeDeviceInfo CompositeDeviceInfo_mut: USB_COMPOSITE_DEVICE_INFO,
    ControllerDeviceInfo ControllerDeviceInfo_mut: USB_CONTROLLER_DEVICE_INFO,
    DeviceInformation DeviceInformation_mut: [UCHAR; 4],
}}
pub type PUSB_DEVICE_NODE_INFO = *mut USB_DEVICE_NODE_INFO;
STRUCT!{#[repr(packed)] struct USB_DEVICE_PERFORMANCE_INFO {
    BulkBytes: ULONG,
    ControlDataBytes: ULONG,
    IsoBytes: ULONG,
    InterruptBytes: ULONG,
    BulkUrbCount: ULONG,
    ControlUrbCount: ULONG,
    IsoUrbCount: ULONG,
    InterruptUrbCount: ULONG,
    AllocedInterrupt: [ULONG; 6],
    AllocedIso: ULONG,
    Total32secBandwidth: ULONG,
    TotalTtBandwidth: ULONG,
    DeviceDescription: [WCHAR; 60],
    DeviceSpeed: USB_DEVICE_SPEED,
    TotalIsoLatency: ULONG,
    DroppedIsoPackets: ULONG,
    TransferErrors: ULONG,
    PciInterruptCount: ULONG,
    HcIdleState: ULONG,
    HcAsyncIdleState: ULONG,
    HcAsyncCacheFlushCount: ULONG,
    HcPeriodicIdleState: ULONG,
    HcPeriodicCacheFlushCount: ULONG,
}}
pub type PUSB_DEVICE_PERFORMANCE_INFO = *mut USB_DEVICE_PERFORMANCE_INFO;
ENUM!{enum USB_HUB_TYPE {
    UsbRootHub = 1,
    Usb20Hub = 2,
    Usb30Hub = 3,
}}
STRUCT!{#[repr(packed)] struct USB_HUB_INFORMATION_EX {
    HubType: USB_HUB_TYPE,
    HighestPortNumber: USHORT,
    u: USB_HUB_INFORMATION_EX_u,
}}
UNION!{union USB_HUB_INFORMATION_EX_u {
    [u8; 71],
    UsbHubDescriptor UsbHubDescriptor_mut: USB_HUB_DESCRIPTOR,
    Usb30HubDescriptor Usb30HubDescriptor_mut: USB_30_HUB_DESCRIPTOR,
}}
pub type PUSB_HUB_INFORMATION_EX = *mut USB_HUB_INFORMATION_EX;
STRUCT!{#[repr(packed)] struct USB_PORT_PROPERTIES {
    ul: ULONG,
}}
BITFIELD!{USB_PORT_PROPERTIES ul: ULONG [
    PortIsUserConnectable set_PortIsUserConnectable[0..1],
    PortIsDebugCapable set_PortIsDebugCapable[1..2],
    PortHasMultipleCompanions set_PortHasMultipleCompanions[2..3],
    PortConnectorIsTypeC set_PortConnectorIsTypeC[3..4],
    ReservedMBZ set_ReservedMBZ[4..32],
]}
pub type PUSB_PORT_PROPERTIES = *mut USB_PORT_PROPERTIES;
STRUCT!{#[repr(packed)] struct USB_PORT_CONNECTOR_PROPERTIES {
    ConnectionIndex: ULONG,
    ActualLength: ULONG,
    UsbPortProperties: USB_PORT_PROPERTIES,
    CompanionIndex: USHORT,
    CompanionPortNumber: USHORT,
    CompanionHubSymbolicLinkName: [WCHAR; 1],
}}
pub type PUSB_PORT_CONNECTOR_PROPERTIES = *mut USB_PORT_CONNECTOR_PROPERTIES;
STRUCT!{#[repr(packed)] struct USB_PROTOCOLS {
    ul: ULONG,
}}
BITFIELD!{USB_PROTOCOLS ul: ULONG [
    Usb110 set_Usb110[0..1],
    Usb200 set_Usb200[1..2],
    Usb300 set_Usb300[2..3],
    ReservedMBZ set_ReservedMBZ[3..32],
]}
pub type PUSB_PROTOCOLS = *mut USB_PROTOCOLS;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS {
    ul: ULONG,
}}
BITFIELD!{USB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS ul: ULONG [
    DeviceIsOperatingAtSuperSpeedOrHigher set_DeviceIsOperatingAtSuperSpeedOrHigher[0..1],
    DeviceIsSuperSpeedCapableOrHigher set_DeviceIsSuperSpeedCapableOrHigher[1..2],
    DeviceIsOperatingAtSuperSpeedPlusOrHigher set_DeviceIsOperatingAtSuperSpeedPlusOrHigher[2..3],
    DeviceIsSuperSpeedPlusCapableOrHigher set_DeviceIsSuperSpeedPlusCapableOrHigher[3..4],
    ReservedMBZ set_ReservedMBZ[4..32],
]}
pub type PUSB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS
    = *mut USB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS;
STRUCT!{#[repr(packed)] struct USB_NODE_CONNECTION_INFORMATION_EX_V2 {
    ConnectionIndex: ULONG,
    Length: ULONG,
    SupportedUsbProtocols: USB_PROTOCOLS,
    Flags: USB_NODE_CONNECTION_INFORMATION_EX_V2_FLAGS,
}}
pub type PUSB_NODE_CONNECTION_INFORMATION_EX_V2 = *mut USB_NODE_CONNECTION_INFORMATION_EX_V2;
pub const USB_TRANSPORT_CHARACTERISTICS_VERSION_1: ULONG = 0x01;
pub const USB_TRANSPORT_CHARACTERISTICS_LATENCY_AVAILABLE: ULONG = 0x1;
pub const USB_TRANSPORT_CHARACTERISTICS_BANDWIDTH_AVAILABLE: ULONG = 0x2;
STRUCT!{#[repr(packed)] struct USB_TRANSPORT_CHARACTERISTICS {
    Version: ULONG,
    TransportCharacteristicsFlags: ULONG,
    CurrentRoundtripLatencyInMilliSeconds: ULONG64,
    MaxPotentialBandwidth: ULONG64,
}}
pub type PUSB_TRANSPORT_CHARACTERISTICS = *mut USB_TRANSPORT_CHARACTERISTICS;
pub const USB_REGISTER_FOR_TRANSPORT_LATENCY_CHANGE: ULONG = 0x1;
pub const USB_REGISTER_FOR_TRANSPORT_BANDWIDTH_CHANGE: ULONG = 0x2;
DECLARE_HANDLE!(USB_CHANGE_REGISTRATION_HANDLE, USB_CHANGE_REGISTRATION_HANDLE__);
STRUCT!{#[repr(packed)] struct USB_TRANSPORT_CHARACTERISTICS_CHANGE_REGISTRATION {
    ChangeNotificationInputFlags: ULONG,
    Handle: USB_CHANGE_REGISTRATION_HANDLE,
    UsbTransportCharacteristics: USB_TRANSPORT_CHARACTERISTICS,
}}
pub type PUSB_TRANSPORT_CHARACTERISTICS_CHANGE_REGISTRATION
    = *mut USB_TRANSPORT_CHARACTERISTICS_CHANGE_REGISTRATION;
STRUCT!{#[repr(packed)] struct USB_TRANSPORT_CHARACTERISTICS_CHANGE_NOTIFICATION {
    Handle: USB_CHANGE_REGISTRATION_HANDLE,
    UsbTransportCharacteristics: USB_TRANSPORT_CHARACTERISTICS,
}}
pub type PUSB_TRANSPORT_CHARACTERISTICS_CHANGE_NOTIFICATION
    = *mut USB_TRANSPORT_CHARACTERISTICS_CHANGE_NOTIFICATION;
STRUCT!{#[repr(packed)] struct USB_TRANSPORT_CHARACTERISTICS_CHANGE_UNREGISTRATION {
    Handle: USB_CHANGE_REGISTRATION_HANDLE,
}}
pub type PUSB_TRANSPORT_CHARACTERISTICS_CHANGE_UNREGISTRATION
    = *mut USB_TRANSPORT_CHARACTERISTICS_CHANGE_UNREGISTRATION;
pub const USB_DEVICE_CHARACTERISTICS_VERSION_1: ULONG = 0x01;
pub const USB_DEVICE_CHARACTERISTICS_MAXIMUM_PATH_DELAYS_AVAILABLE: ULONG = 0x1;
STRUCT!{#[repr(packed)] struct USB_DEVICE_CHARACTERISTICS {
    Version: ULONG,
    Reserved: [ULONG; 2],
    UsbDeviceCharacteristicsFlags: ULONG,
    MaximumSendPathDelayInMilliSeconds: ULONG,
    MaximumCompletionPathDelayInMilliSeconds: ULONG,
}}
pub type PUSB_DEVICE_CHARACTERISTICS = *mut USB_DEVICE_CHARACTERISTICS;
STRUCT!{#[repr(packed)] struct USB_START_TRACKING_FOR_TIME_SYNC_INFORMATION {
    TimeTrackingHandle: HANDLE,
    IsStartupDelayTolerable: BOOLEAN,
}}
pub type PUSB_START_TRACKING_FOR_TIME_SYNC_INFORMATION
    = *mut USB_START_TRACKING_FOR_TIME_SYNC_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_STOP_TRACKING_FOR_TIME_SYNC_INFORMATION {
    TimeTrackingHandle: HANDLE,
}}
pub type PUSB_STOP_TRACKING_FOR_TIME_SYNC_INFORMATION
    = *mut USB_STOP_TRACKING_FOR_TIME_SYNC_INFORMATION;
STRUCT!{#[repr(packed)] struct USB_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC_INFORMATION {
    TimeTrackingHandle: HANDLE,
    InputFrameNumber: ULONG,
    InputMicroFrameNumber: ULONG,
    QueryPerformanceCounterAtInputFrameOrMicroFrame: LARGE_INTEGER,
    QueryPerformanceCounterFrequency: LARGE_INTEGER,
    PredictedAccuracyInMicroSeconds: ULONG,
    CurrentGenerationID: ULONG,
    CurrentQueryPerformanceCounter: LARGE_INTEGER,
    CurrentHardwareFrameNumber: ULONG,
    CurrentHardwareMicroFrameNumber: ULONG,
    CurrentUSBFrameNumber: ULONG,
}}
pub type PUSB_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC_INFORMATION
    = *mut USB_FRAME_NUMBER_AND_QPC_FOR_TIME_SYNC_INFORMATION;
