/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.Tenancy;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeReservedInstancesOfferings
extends BaseCmd {
    private static final String PRODUCT_DESCRIPTION_ARG = "DESCRIPTION";
    private static final String PRODUCT_DESCRIPTION = "description";
    private static final String TYPE_ARG = "INSTANCE-TYPE";
    private static final String TYPE = "type";
    private static final String ZONE_ARG = "ZONE";
    private static final String ZONE = "availability-zone";
    private static final String OFFERING_TYPE = "offering-type";
    private static final String MIN_DURATION = "min-duration";
    private static final String MIN_DURATION_ARG = "MIN-DURATION";
    private static final String MAX_DURATION = "max-duration";
    private static final String MAX_DURATION_ARG = "MAX-DURATION";
    private static final String OFFERING_TYPE_ARG = "OFFERING-TYPE";
    private static final String EXCLUDE_MARKETPLACE = "exclude-marketplace";
    private static final String[] OFFERING_TYPE_DESC = new String[]{"Specifies the offering type, which relates to the billing model", "used for the offering."};
    private static final String[] TENANCY_DESC = new String[]{"Specifies the tenancy of the instances, which can be default or dedicated.", " - default: Tenancy is not restricted.", " - dedicated: The instance will run on single-tenant hardware,", "   additional charges will apply."};
    private static final String[] EXCLUDE_MARKETPLACE_DESC = new String[]{"Specifies that Reserved Instance Marketplace offerings should not be shown", "in the results."};
    private static final String[] MIN_DURATION_DESC = new String[]{"Specifies that only results which have a duration of at least", "MIN-DURATION months should be returned."};
    private static final String[] MAX_DURATION_DESC = new String[]{"Specifies that only results which have a duration of at most", "MAX-DURATION months should be returned."};
    private static final Long YEAR_SECS = 31536000L;
    private static final Long RI_MONTH_SECS = 2592000L;

    public DescribeReservedInstancesOfferings(String[] args) {
        super("ec2drio", "ec2-describe-reserved-instances-offerings");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)ZONE);
        OptionBuilder.withDescription((String)this.joinDescription("Find offerings in the specifed availability zone."));
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)ZONE_ARG);
        result.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withLongOpt((String)TYPE);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Find offerings for the specified instance type."));
        OptionBuilder.withArgName((String)TYPE_ARG);
        result.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)PRODUCT_DESCRIPTION);
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)this.joinDescription("Find offerings containing the following product description"));
        OptionBuilder.withArgName((String)PRODUCT_DESCRIPTION_ARG);
        result.addOption(OptionBuilder.create((String)"d"));
        result.addOption(DescribeReservedInstancesOfferings.createOptionWithArgs(null, "tenancy", TENANCY_DESC, "TENANCY"));
        result.addOption(DescribeReservedInstancesOfferings.createOptionWithArgs(null, OFFERING_TYPE, OFFERING_TYPE_DESC, OFFERING_TYPE_ARG));
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        result.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withLongOpt((String)EXCLUDE_MARKETPLACE);
        OptionBuilder.withDescription((String)DescribeReservedInstancesOfferings.joinDescription(EXCLUDE_MARKETPLACE_DESC));
        result.addOption(OptionBuilder.create(null));
        OptionBuilder.withLongOpt((String)MIN_DURATION);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)MIN_DURATION_ARG);
        OptionBuilder.withDescription((String)DescribeReservedInstancesOfferings.joinDescription(MIN_DURATION_DESC));
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)MAX_DURATION);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)MAX_DURATION_ARG);
        OptionBuilder.withDescription((String)DescribeReservedInstancesOfferings.joinDescription(MAX_DURATION_DESC));
        result.addOption(OptionBuilder.create());
        return result;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Returns information about Reserved Instance offerings that are available");
        System.out.println("     for purchase. If no parameter is specified with this command, information");
        System.out.println("     about all Reserved Instance offerings will be returned.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(ZONE);
        this.printOption(TYPE);
        this.printOption(PRODUCT_DESCRIPTION);
        this.printOption("tenancy");
        this.printOption(OFFERING_TYPE);
        this.printOption("filter");
        this.printOption(EXCLUDE_MARKETPLACE);
        this.printOption(MIN_DURATION);
        this.printOption(MAX_DURATION);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        Tenancy tenancy;
        if (this.isOptionSet("tenancy")) {
            String value = this.getOptionValue("tenancy");
            tenancy = Tenancy.toTenancy((String)value);
            if (null == tenancy) {
                throw new InvalidArgument("tenancy", value);
            }
        } else {
            tenancy = null;
        }
        String offeringType = this.isOptionSet(OFFERING_TYPE) ? this.getOptionValue(OFFERING_TYPE) : null;
        Long min = null;
        Long max = null;
        if (this.isOptionSet(MIN_DURATION)) {
            try {
                min = Long.parseLong(this.getOptionValue(MIN_DURATION));
                min = min % 12L == 0L ? Long.valueOf(min / 12L * YEAR_SECS) : Long.valueOf(min * RI_MONTH_SECS);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument(MIN_DURATION, this.getOptionValue(MIN_DURATION));
            }
        }
        if (this.isOptionSet(MAX_DURATION)) {
            try {
                max = Long.parseLong(this.getOptionValue(MAX_DURATION));
                max = max % 12L == 0L ? Long.valueOf(max / 12L * YEAR_SECS) : Long.valueOf(max * RI_MONTH_SECS);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument(MAX_DURATION, this.getOptionValue(MAX_DURATION));
            }
        }
        String nextToken = null;
        do {
            rsp = jec2.describeReservedInstancesOfferings(Arrays.asList(this.getNonOptions()), this.getOptionValue(ZONE), this.getOptionValue(TYPE), this.getOptionValue(PRODUCT_DESCRIPTION), tenancy, offeringType, Boolean.valueOf(!this.isOptionSet(EXCLUDE_MARKETPLACE)), min, max, nextToken, this.getFilters(true));
            out.outputReservedInstanceOfferings(System.out, (List)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
        } while (null != (nextToken = rsp.getNextToken()));
        return true;
    }

    @Override
    protected String getOptionString() {
        return "[OFFERING [OFFERING [...]]] [-z ZONE] [-t INSTANCE-TYPE] [-d DESCRIPTION] [--tenancy TENANCY] [--offering-type OFFERING-TYPE]";
    }

    public static void main(String[] args) {
        new DescribeReservedInstancesOfferings(args).invoke();
    }
}

