/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import javax.xml.crypto.test.dsig.SignatureValidator;
import javax.xml.crypto.test.dsig.X509KeySelector;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;

public class Baltimore23Test
extends TestCase {
    private SignatureValidator validator;
    private File dir;
    private final URIDereferencer ud;

    public Baltimore23Test(String string) {
        super(string);
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string3 + string2 + "data" + string2 + "ie" + string2 + "baltimore" + string2 + "merlin-examples", "merlin-xmldsig-twenty-three");
        this.validator = new SignatureValidator(this.dir);
        this.ud = new LocalHttpCacheURIDereferencer();
    }

    public void test_signature_enveloped_dsa() throws Exception {
        String string = "signature-enveloped-dsa.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_enveloping_b64_dsa() throws Exception {
        String string = "signature-enveloping-b64-dsa.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_enveloping_dsa() throws Exception {
        String string = "signature-enveloping-dsa.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_external_b64_dsa() throws Exception {
        String string = "signature-external-b64-dsa.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_external_dsa() throws Exception {
        String string = "signature-external-dsa.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector(), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_enveloping_rsa() throws Exception {
        String string = "signature-enveloping-rsa.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.KeyValueKeySelector());
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_enveloping_hmac_sha1() throws Exception {
        String string = "signature-enveloping-hmac-sha1.xml";
        KeySelectors.SecretKeySelector secretKeySelector = new KeySelectors.SecretKeySelector("secret".getBytes("ASCII"));
        boolean bl = this.validator.validate(string, secretKeySelector);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_enveloping_hmac_sha1_40() throws Exception {
        String string = "signature-enveloping-hmac-sha1-40.xml";
        KeySelectors.SecretKeySelector secretKeySelector = new KeySelectors.SecretKeySelector("secret".getBytes("ASCII"));
        try {
            boolean bl = this.validator.validate(string, secretKeySelector);
            Baltimore23Test.fail((String)"Expected HMACOutputLength exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println(xMLSignatureException.getMessage());
        }
    }

    public void test_signature_keyname() throws Exception {
        String string = "signature-keyname.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.dir), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_retrievalmethod_rawx509crt() throws Exception {
        String string = "signature-retrievalmethod-rawx509crt.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.dir), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_x509_crt_crl() throws Exception {
        String string = "signature-x509-crt-crl.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector(), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_x509_crt() throws Exception {
        String string = "signature-x509-crt.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.RawX509KeySelector(), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_x509_is() throws Exception {
        String string = "signature-x509-is.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.dir), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_x509_ski() throws Exception {
        String string = "signature-x509-ski.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.dir), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_x509_sn() throws Exception {
        String string = "signature-x509-sn.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.CollectionKeySelector(this.dir), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature() throws Exception {
        String string = "signature.xml";
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        String string4 = string3 + string2 + "data" + string2 + "ie" + string2 + "baltimore" + string2 + "merlin-examples" + string2 + "merlin-xmldsig-twenty-three" + string2 + "certs" + string2 + "xmldsig.jks";
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new FileInputStream(string4), "changeit".toCharArray());
        boolean bl = this.validator.validate(string, new X509KeySelector(keyStore, false), this.ud);
        Baltimore23Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public static void main(String[] stringArray) throws Exception {
        Baltimore23Test baltimore23Test = new Baltimore23Test("");
        baltimore23Test.test_signature_enveloped_dsa();
        baltimore23Test.test_signature();
        baltimore23Test.test_signature_enveloping_b64_dsa();
        baltimore23Test.test_signature_enveloping_dsa();
        baltimore23Test.test_signature_enveloping_hmac_sha1();
        baltimore23Test.test_signature_enveloping_hmac_sha1_40();
        baltimore23Test.test_signature_enveloping_rsa();
        baltimore23Test.test_signature_external_b64_dsa();
        baltimore23Test.test_signature_external_dsa();
        baltimore23Test.test_signature_keyname();
        baltimore23Test.test_signature_retrievalmethod_rawx509crt();
        baltimore23Test.test_signature_x509_crt_crl();
        baltimore23Test.test_signature_x509_crt();
        baltimore23Test.test_signature_x509_is();
        baltimore23Test.test_signature_x509_ski();
        baltimore23Test.test_signature_x509_sn();
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

