/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class MergeTranslations {
    public static void main(String[] args) throws Exception {
        String localeKey;
        String[] sourceFiles;
        File targetDirectory;
        File sourceDirectory = new File(args[0]);
        if (!sourceDirectory.isDirectory()) {
            System.exit(1);
        }
        if (!(targetDirectory = new File(args[1])).isDirectory()) {
            System.exit(1);
        }
        if ((sourceFiles = sourceDirectory.list(new FilenameFilter(localeKey = args.length > 2 ? args[2] : ""){
            final /* synthetic */ String val$localeKey;
            {
                this.val$localeKey = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("FreeColMessages_" + this.val$localeKey + ".*\\.properties");
            }
        })) == null) {
            System.err.println("No messages files found in " + sourceDirectory);
            System.exit(1);
        }
        for (String name : sourceFiles) {
            System.out.println("Processing source file: " + name);
            File sourceFile = new File(sourceDirectory, name);
            Map<String, String> sourceProperties = MergeTranslations.readFile(sourceFile);
            File targetFile = new File(targetDirectory, name);
            if (targetFile.exists()) {
                Map<String, String> targetProperties = MergeTranslations.readFile(targetFile);
                List<Map.Entry> missingProperties = CollectionUtils.transform(sourceProperties.entrySet(), e -> !targetProperties.containsKey(e.getKey()));
                if (missingProperties.isEmpty()) continue;
                try (Writer out = Utils.getFileUTF8AppendWriter(targetFile);){
                    out.write("### Merged from trunk on " + DateFormat.getDateTimeInstance().format(new Date()) + " ###\n");
                    for (Map.Entry entry : missingProperties) {
                        out.write((String)entry.getKey());
                        out.write("=");
                        out.write((String)entry.getValue());
                        out.write("\n");
                    }
                    continue;
                }
            }
            System.out.println("Copying " + name + " from trunk.");
            try (Reader in = Utils.getFileUTF8Reader(sourceFile);
                 Writer out = Utils.getFileUTF8Writer(targetFile);){
                int c;
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
            }
        }
    }

    private static Map<String, String> readFile(File file) {
        HashMap<String, String> result = new HashMap<String, String>();
        try (Reader reader = Utils.getFileUTF8Reader(file);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index >= 0) {
                    result.put(line.substring(0, index), line.substring(index + 1));
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException ioe) {
            System.err.println("Error reading file " + file.getName() + ": " + ioe);
        }
        return result;
    }
}

