/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.osgi.util.function.Consumer;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.promise.PromiseImpl;
import org.osgi.util.promise.Success;

final class FailedPromiseImpl<T>
extends PromiseImpl<T> {
    private final Throwable fail;

    FailedPromiseImpl(Throwable fail, PromiseFactory factory) {
        super(factory);
        this.fail = Objects.requireNonNull(fail);
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T getValue() throws InvocationTargetException {
        throw new InvocationTargetException(this.fail);
    }

    @Override
    public Throwable getFailure() {
        return this.fail;
    }

    @Override
    void result(PromiseImpl.Result<? super T> consumer) {
        consumer.accept(null, this.fail);
    }

    public String toString() {
        return super.toString() + "[failed: " + this.fail + "]";
    }

    private <V> FailedPromiseImpl<V> coerce() {
        return this;
    }

    @Override
    public Promise<T> onSuccess(Consumer<? super T> success) {
        Objects.requireNonNull(success);
        return this;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        if (failure == null) {
            return this.coerce();
        }
        return super.then(success, failure);
    }

    @Override
    public Promise<T> thenAccept(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        return this;
    }

    @Override
    public Promise<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this;
    }

    @Override
    public <R> Promise<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return this.coerce();
    }

    @Override
    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.coerce();
    }

    @Override
    public Promise<T> timeout(long millis) {
        return this;
    }

    @Override
    public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(this.fail);
        return completableFuture;
    }
}

