/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.Certificate;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.TransientSessionKeyManager;
import net.i2p.router.crypto.ratchet.MuxedPQSKM;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.router.util.RemovableSingletonSet;

public class MessageWrapper {
    private static final int NETDB_TAGS_TO_DELIVER = 6;
    private static final int NETDB_LOW_THRESHOLD = 3;

    static WrappedMessage wrap(RouterContext ctx, I2NPMessage m, Hash from, RouterInfo to) {
        PublicKey sentTo = to.getIdentity().getPublicKey();
        if (sentTo.getType() != EncType.ELGAMAL_2048) {
            return null;
        }
        PayloadGarlicConfig payload = new PayloadGarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), m.getMessageExpiration(), DeliveryInstructions.LOCAL, m);
        payload.setRecipient(to);
        SessionKeyManager skm = from != null ? ctx.clientManager().getClientSessionKeyManager(from) : ctx.sessionKeyManager();
        if (skm == null) {
            return null;
        }
        SessionKey sentKey = new SessionKey();
        HashSet<SessionTag> sentTags = new HashSet<SessionTag>(6);
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, payload, sentKey, sentTags, 6, 3, skm);
        if (msg == null) {
            return null;
        }
        TagSetHandle tsh = null;
        if (!sentTags.isEmpty()) {
            tsh = skm.tagsDelivered(sentTo, sentKey, sentTags);
        }
        return new WrappedMessage(msg, skm, sentTo, sentKey, tsh);
    }

    public static GarlicMessage wrap(RouterContext ctx, I2NPMessage m, RouterInfo to) {
        GarlicMessage msg;
        PayloadGarlicConfig payload = new PayloadGarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), m.getMessageExpiration(), DeliveryInstructions.LOCAL, m);
        payload.setRecipient(to);
        PublicKey key = to.getIdentity().getPublicKey();
        EncType type = key.getType();
        if (type == EncType.ELGAMAL_2048) {
            SessionKey sentKey = ctx.keyGenerator().generateSessionKey();
            msg = GarlicMessageBuilder.buildMessage(ctx, (GarlicConfig)payload, null, key, sentKey, null);
        } else if (type == EncType.ECIES_X25519) {
            payload.setRecipientPublicKey(key);
            msg = GarlicMessageBuilder.buildECIESMessage(ctx, payload);
        } else {
            msg = null;
        }
        return msg;
    }

    public static OneTimeSession generateSession(RouterContext ctx, long expiration) {
        return MessageWrapper.generateSession(ctx, ctx.sessionKeyManager(), expiration, false);
    }

    public static OneTimeSession generateSession(RouterContext ctx, Hash localDest, long expiration, boolean forceElG) {
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(localDest);
        if (skm == null) {
            return null;
        }
        return MessageWrapper.generateSession(ctx, skm, expiration, forceElG);
    }

    public static OneTimeSession generateSession(RouterContext ctx, SessionKeyManager skm, long expiration, boolean forceElG) {
        RatchetSKM rskm;
        SessionKey key = ctx.keyGenerator().generateSessionKey();
        if (forceElG || skm instanceof TransientSessionKeyManager) {
            SessionTag tag = new SessionTag(true);
            RemovableSingletonSet<SessionTag> tags = new RemovableSingletonSet<SessionTag>(tag);
            skm.tagsReceived(key, tags, expiration);
            return new OneTimeSession(key, tag);
        }
        if (skm instanceof RatchetSKM) {
            rskm = (RatchetSKM)skm;
        } else if (skm instanceof MuxedSKM) {
            rskm = ((MuxedSKM)skm).getECSKM();
        } else if (skm instanceof MuxedPQSKM) {
            rskm = ((MuxedPQSKM)skm).getECSKM();
        } else {
            throw new IllegalStateException("skm not a ratchet " + skm);
        }
        RatchetSessionTag tag = new RatchetSessionTag(ctx.random().nextLong());
        rskm.tagsReceived(key, tag, expiration);
        return new OneTimeSession(key, tag);
    }

    public static GarlicMessage wrap(RouterContext ctx, I2NPMessage m, OneTimeSession session) {
        if (session.tag != null) {
            return MessageWrapper.wrap(ctx, m, session.key, session.tag);
        }
        return MessageWrapper.wrap(ctx, m, session.key, session.rtag);
    }

    public static GarlicMessage wrap(RouterContext ctx, I2NPMessage m, SessionKey encryptKey, SessionTag encryptTag) {
        PayloadGarlicConfig payload = new PayloadGarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), m.getMessageExpiration(), DeliveryInstructions.LOCAL, m);
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, (GarlicConfig)payload, null, null, encryptKey, encryptTag);
        return msg;
    }

    public static GarlicMessage wrap(RouterContext ctx, I2NPMessage m, SessionKey encryptKey, RatchetSessionTag encryptTag) {
        PayloadGarlicConfig payload = new PayloadGarlicConfig(Certificate.NULL_CERT, ctx.random().nextLong(0xFFFFFFFFL), m.getMessageExpiration(), DeliveryInstructions.LOCAL, m);
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, payload, encryptKey, encryptTag);
        return msg;
    }

    public static class OneTimeSession {
        public final SessionKey key;
        public final SessionTag tag;
        public final RatchetSessionTag rtag;

        public OneTimeSession(SessionKey key, SessionTag tag) {
            this.key = key;
            this.tag = tag;
            this.rtag = null;
        }

        public OneTimeSession(SessionKey key, RatchetSessionTag tag) {
            this.key = key;
            this.rtag = tag;
            this.tag = null;
        }
    }

    static class WrappedMessage {
        private GarlicMessage msg;
        private SessionKeyManager skm;
        private PublicKey sentTo;
        private SessionKey sessionKey;
        private TagSetHandle tsh;

        WrappedMessage(GarlicMessage msg, SessionKeyManager skm, PublicKey sentTo, SessionKey sentKey, TagSetHandle tsh) {
            this.msg = msg;
            this.skm = skm;
            this.sentTo = sentTo;
            this.sessionKey = sentKey;
            this.tsh = tsh;
        }

        GarlicMessage getMessage() {
            return this.msg;
        }

        void acked() {
            if (this.tsh != null) {
                this.skm.tagsAcked(this.sentTo, this.sessionKey, this.tsh);
            }
        }

        void fail() {
            if (this.tsh != null) {
                this.skm.failTags(this.sentTo, this.sessionKey, this.tsh);
            }
        }
    }
}

