/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.Arrays;
import nokogiri.XmlDocument;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::NodeSet"})
public class XmlNodeSet
extends RubyObject
implements NodeList {
    private static final long serialVersionUID = 1L;
    IRubyObject[] nodes;

    public XmlNodeSet(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.nodes = IRubyObject.NULL_ARRAY;
    }

    XmlNodeSet(Ruby ruby, RubyClass rubyClass, IRubyObject[] iRubyObjectArray) {
        super(ruby, rubyClass);
        this.nodes = iRubyObjectArray;
    }

    public static XmlNodeSet newEmptyNodeSet(ThreadContext threadContext, XmlNodeSet xmlNodeSet) {
        Ruby ruby = threadContext.runtime;
        XmlNodeSet xmlNodeSet2 = new XmlNodeSet(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"));
        xmlNodeSet2.initializeFrom(threadContext, xmlNodeSet);
        return xmlNodeSet2;
    }

    public static XmlNodeSet newEmptyNodeSet(ThreadContext threadContext, XmlNode xmlNode) {
        Ruby ruby = threadContext.runtime;
        XmlNodeSet xmlNodeSet = new XmlNodeSet(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"));
        xmlNodeSet.initialize(ruby, (IRubyObject)xmlNode);
        return xmlNodeSet;
    }

    public static XmlNodeSet newNodeSet(Ruby ruby, IRubyObject[] iRubyObjectArray) {
        XmlNodeSet xmlNodeSet = new XmlNodeSet(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"));
        xmlNodeSet.setNodes(iRubyObjectArray);
        return xmlNodeSet;
    }

    public static XmlNodeSet newNodeSet(Ruby ruby, IRubyObject[] iRubyObjectArray, XmlNode xmlNode) {
        XmlNodeSet xmlNodeSet = new XmlNodeSet(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"), iRubyObjectArray);
        xmlNodeSet.initialize(ruby, (IRubyObject)xmlNode);
        return xmlNodeSet;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void setNodes(IRubyObject[] iRubyObjectArray) {
        this.nodes = iRubyObjectArray;
        IRubyObject iRubyObject = iRubyObjectArray.length > 0 ? iRubyObjectArray[0] : null;
        this.initialize(this.getRuntime(), iRubyObject);
    }

    private void initializeFrom(ThreadContext threadContext, XmlNodeSet xmlNodeSet) {
        IRubyObject iRubyObject = xmlNodeSet.getInstanceVariable("@document");
        if (iRubyObject != null && !iRubyObject.isNil()) {
            this.initialize(threadContext, (XmlDocument)iRubyObject);
        }
    }

    final void initialize(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode) {
            XmlDocument xmlDocument = ((XmlNode)iRubyObject).document(ruby);
            XmlNode.setDocumentAndDecorate(ruby.getCurrentContext(), this, xmlDocument);
        }
    }

    private void initialize(ThreadContext threadContext, XmlDocument xmlDocument) {
        XmlNode.setDocumentAndDecorate(threadContext, this, xmlDocument);
    }

    public int length() {
        return this.nodes == null ? 0 : this.nodes.length;
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = XmlNodeSet.getNodes(threadContext, iRubyObject);
        if (iRubyObjectArray == null || iRubyObjectArray.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext, this);
        }
        if (this.nodes == null || this.nodes.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext, this);
        }
        IRubyObject[] iRubyObjectArray2 = this.nodes;
        IRubyObject[] iRubyObjectArray3 = XmlNodeSet.getNodes(threadContext, iRubyObject);
        IRubyObject[] iRubyObjectArray4 = new IRubyObject[this.nodes.length];
        int n = 0;
        block0: for (int i = 0; i < iRubyObjectArray2.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray2[i];
            for (int j = 0; j < iRubyObjectArray3.length; ++j) {
                if (iRubyObjectArray3[j] != iRubyObject2) continue;
                iRubyObjectArray4[n++] = iRubyObject2;
                continue block0;
            }
        }
        XmlNodeSet xmlNodeSet = XmlNodeSet.newNodeSet(threadContext.runtime, Arrays.copyOf(iRubyObjectArray4, n));
        xmlNodeSet.initializeFrom(threadContext, this);
        return xmlNodeSet;
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = XmlNodeSet.asXmlNodeOrNamespace(threadContext, iRubyObject);
        if (this.nodes.length == 0) {
            return threadContext.nil;
        }
        IRubyObject[] iRubyObjectArray = this.nodes;
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[this.nodes.length];
        int n = 0;
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            IRubyObject iRubyObject3 = iRubyObjectArray[i];
            if (iRubyObject3 == iRubyObject2) continue;
            iRubyObjectArray2[n++] = iRubyObject3;
        }
        this.nodes = Arrays.copyOf(iRubyObjectArray2, n);
        if (this.nodes.length < iRubyObjectArray.length) {
            return iRubyObject2;
        }
        return threadContext.nil;
    }

    public IRubyObject dup(ThreadContext threadContext) {
        XmlNodeSet xmlNodeSet = XmlNodeSet.newNodeSet(threadContext.runtime, (IRubyObject[])this.nodes.clone());
        xmlNodeSet.initializeFrom(threadContext, this);
        return xmlNodeSet;
    }

    @JRubyMethod(visibility=Visibility.PROTECTED)
    public IRubyObject initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setNodes(XmlNodeSet.getNodes(threadContext, iRubyObject));
        this.initializeFrom(threadContext, (XmlNodeSet)iRubyObject);
        return this;
    }

    @JRubyMethod(name={"include?"})
    public IRubyObject include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != iRubyObject) continue;
            return threadContext.tru;
        }
        return threadContext.fals;
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length(ThreadContext threadContext) {
        return threadContext.runtime.newFixnum(this.nodes.length);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_diff(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = XmlNodeSet.getNodes(threadContext, iRubyObject);
        if (iRubyObjectArray.length == 0) {
            return this.dup(threadContext);
        }
        if (this.nodes.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext, this);
        }
        IRubyObject[] iRubyObjectArray2 = this.nodes;
        IRubyObject[] iRubyObjectArray3 = XmlNodeSet.getNodes(threadContext, iRubyObject);
        IRubyObject[] iRubyObjectArray4 = new IRubyObject[this.nodes.length];
        int n = 0;
        block0: for (int i = 0; i < iRubyObjectArray2.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray2[i];
            for (int j = 0; j < iRubyObjectArray3.length; ++j) {
                if (iRubyObjectArray3[j] == iRubyObject2) continue block0;
            }
            iRubyObjectArray4[n++] = iRubyObject2;
        }
        XmlNodeSet xmlNodeSet = XmlNodeSet.newNodeSet(threadContext.runtime, Arrays.copyOf(iRubyObjectArray4, n));
        xmlNodeSet.initializeFrom(threadContext, this);
        return xmlNodeSet;
    }

    @JRubyMethod(name={"|", "+"})
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = XmlNodeSet.getNodes(threadContext, iRubyObject);
        if (this.nodes.length == 0) {
            return ((XmlNodeSet)iRubyObject).dup(threadContext);
        }
        if (iRubyObjectArray.length == 0) {
            return this.dup(threadContext);
        }
        IRubyObject[] iRubyObjectArray2 = this.nodes;
        IRubyObject[] iRubyObjectArray3 = XmlNodeSet.getNodes(threadContext, iRubyObject);
        IRubyObject[] iRubyObjectArray4 = Arrays.copyOf(iRubyObjectArray2, iRubyObjectArray2.length + iRubyObjectArray3.length);
        int n = iRubyObjectArray2.length;
        block0: for (int i = 0; i < iRubyObjectArray3.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray3[i];
            for (int j = 0; j < iRubyObjectArray2.length; ++j) {
                if (iRubyObjectArray2[j] == iRubyObject2) continue block0;
            }
            iRubyObjectArray4[n++] = iRubyObject2;
        }
        XmlNodeSet xmlNodeSet = XmlNodeSet.newNodeSet(threadContext.runtime, Arrays.copyOf(iRubyObjectArray4, n));
        xmlNodeSet.initializeFrom(threadContext, this);
        return xmlNodeSet;
    }

    @JRubyMethod(name={"push", "<<"})
    public IRubyObject push(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        this.nodes[this.nodes.length - 1] = iRubyObject;
        return this;
    }

    private static IRubyObject rangeBeginLength(ThreadContext threadContext, IRubyObject iRubyObject, int n, int[] nArray) {
        RubyRange rubyRange = (RubyRange)iRubyObject;
        int n2 = rubyRange.begin(threadContext).convertToInteger().getIntValue();
        int n3 = rubyRange.end(threadContext).convertToInteger().getIntValue();
        if (n2 < 0 && (n2 += n) < 0) {
            throw threadContext.runtime.newRangeError(n2 + ".." + (rubyRange.isExcludeEnd() ? "." : "") + n3 + " out of range");
        }
        if (n3 < 0) {
            n3 += n;
        }
        if (!rubyRange.isExcludeEnd()) {
            // empty if block
        }
        nArray[0] = n2;
        nArray[1] = ++n3;
        return threadContext.tru;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            return this.slice(threadContext, ((RubyFixnum)iRubyObject).getIntValue());
        }
        if (iRubyObject instanceof RubyRange) {
            int[] nArray = new int[2];
            XmlNodeSet.rangeBeginLength(threadContext, iRubyObject, this.nodes.length, nArray);
            int n = nArray[0];
            int n2 = nArray[1];
            return this.subseq(threadContext, n, n2 - n);
        }
        throw threadContext.runtime.newTypeError("index must be an Integer or a Range");
    }

    IRubyObject slice(ThreadContext threadContext, int n) {
        if (n < 0) {
            n += this.nodes.length;
        }
        if (n >= this.nodes.length || n < 0) {
            return threadContext.nil;
        }
        return this.nodes[n];
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = ((RubyFixnum)iRubyObject).getIntValue();
        int n2 = ((RubyFixnum)iRubyObject2).getIntValue();
        if (n < 0) {
            n += this.nodes.length;
        }
        return this.subseq(threadContext, n, n2);
    }

    public IRubyObject subseq(ThreadContext threadContext, int n, int n2) {
        if (n > this.nodes.length) {
            return threadContext.nil;
        }
        if (n < 0 || n2 < 0) {
            return threadContext.nil;
        }
        if (n + n2 > this.nodes.length) {
            n2 = this.nodes.length - n;
        }
        int n3 = n + n2;
        return XmlNodeSet.newNodeSet(threadContext.runtime, Arrays.copyOfRange(this.nodes, n, n3));
    }

    @JRubyMethod(name={"to_a", "to_ary"})
    public RubyArray<?> to_a(ThreadContext threadContext) {
        return threadContext.runtime.newArrayNoCopy(this.nodes);
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!(this.nodes[i] instanceof XmlNode)) continue;
            ((XmlNode)this.nodes[i]).unlink(threadContext);
        }
        return this;
    }

    private static IRubyObject asXmlNodeOrNamespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode || iRubyObject instanceof XmlNamespace) {
            return iRubyObject;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::Node or Nokogiri::XML::Namespace");
    }

    private static IRubyObject[] getNodes(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNodeSet) {
            return ((XmlNodeSet)iRubyObject).nodes;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::NodeSet");
    }

    @Override
    public int getLength() {
        return this.nodes.length;
    }

    @Override
    public Node item(int n) {
        IRubyObject iRubyObject = this.nodes[n];
        if (iRubyObject instanceof XmlNode) {
            return ((XmlNode)iRubyObject).node;
        }
        if (iRubyObject instanceof XmlNamespace) {
            return ((XmlNamespace)iRubyObject).getNode();
        }
        return null;
    }
}

