/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealLastIndexKeyScanStatistics
extends RealNoPutResultSetStatistics {
    public String isolationLevel;
    public String tableName;
    public String indexName;
    public String lockString;

    public RealLastIndexKeyScanStatistics(int numOpens, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String indexName, String isolationLevel, String lockString, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, 1, 0, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.indexName = indexName;
        this.isolationLevel = isolationLevel;
        this.lockString = lockString;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        Object isolationString = null;
        this.initFormatInfo(depth);
        String header = this.indent + MessageService.getTextMessage((String)"43X71.U", (Object[])new Object[]{this.tableName, this.indexName});
        header = header + MessageService.getTextMessage((String)"43X72.U", (Object[])new Object[]{this.isolationLevel, this.lockString});
        header = header + "\n";
        return header + this.indent + MessageService.getTextMessage((String)"43X03.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage((String)"43X04.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (String)(this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage((String)"43X33.U", (Object[])new Object[0]) + " = " + this.nextTime / (long)this.numOpens + "\n" : "") + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)(this.indexName == null ? "43X73.U" : "43X74.U"), (Object[])new Object[0]);
    }

    @Override
    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage((String)"43X75.U", (Object[])new Object[]{this.tableName});
        }
        return MessageService.getTextMessage((String)"43X38.U", (Object[])new Object[]{this.tableName, this.indexName});
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        return "LASTINDEXKEYSCAN";
    }

    @Override
    public String getRSXplainDetails() {
        return "I: " + this.indexName + ", T: " + this.tableName;
    }

    @Override
    public Object getScanPropsDescriptor(Object scanPropsID) {
        String isoLevel = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        XPLAINScanPropsDescriptor scanRSDescriptor = new XPLAINScanPropsDescriptor((UUID)scanPropsID, this.indexName, "I", null, isoLevel, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        return scanRSDescriptor;
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        String lockMode = XPLAINUtil.getLockModeCode(this.lockString);
        String lockGran = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, lockMode, lockGran, (UUID)parentID, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeen, null, this.rowsFiltered, this.rowsSeen - this.rowsFiltered, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

