/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.security;

import ca.sqlpower.security.PLGroup;
import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.security.PLSecurityManager;
import ca.sqlpower.security.PLUser;
import ca.sqlpower.sql.DatabaseObject;
import ca.sqlpower.sql.SQL;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class EmailNotification
implements Serializable {
    public static final String RED_STATUS = "EMAIL_RED_IND";
    public static final String YELLOW_STATUS = "EMAIL_YELLOW_IND";
    public static final String GREEN_STATUS = "EMAIL_GREEN_IND";

    public static void setPref(Connection con, PLSecurityManager sm, PLUser notifyUser, DatabaseObject notifyAbout, String viewKpi, String emailRed, String emailYellow, String emailGreen) throws SQLException, PLSecurityException {
        sm.checkModify(con, notifyUser);
        EmailNotification.setPref(con, notifyUser.getUserId(), true, notifyAbout, viewKpi, emailRed, emailYellow, emailGreen);
    }

    public static void setPref(Connection con, PLSecurityManager sm, PLGroup notifyGroup, DatabaseObject notifyAbout, String viewKpi, String emailRed, String emailYellow, String emailGreen) throws SQLException, PLSecurityException {
        sm.checkModify(con, notifyGroup);
        EmailNotification.setPref(con, notifyGroup.getGroupName(), false, notifyAbout, viewKpi, emailRed, emailYellow, emailGreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setPref(Connection con, String notifyName, boolean nameIsUser, DatabaseObject notifyAbout, String viewKpi, String emailRed, String emailYellow, String emailGreen) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        boolean bFirst = true;
        try {
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            if (nameIsUser) {
                sql.append("SELECT count(*) FROM pl_user_notification");
                sql.append(" WHERE user_id=");
            } else {
                sql.append("SELECT count(*) FROM pl_group_notification");
                sql.append(" WHERE group_name=");
            }
            sql.append(SQL.quote(notifyName));
            sql.append(" AND object_type=").append(SQL.quote(notifyAbout.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(notifyAbout.getObjectName()));
            rs = stmt.executeQuery(sql.toString());
            sql.setLength(0);
            if (rs.next()) {
                int rowCount = rs.getInt(1);
                if (rowCount > 0) {
                    if (nameIsUser) {
                        sql.append("UPDATE pl_user_notification");
                    } else {
                        sql.append("UPDATE pl_group_notification");
                    }
                    sql.append(" SET");
                    if (!viewKpi.equals("")) {
                        sql.append(" view_kpi_ind=").append(SQL.quote(viewKpi));
                        bFirst = false;
                    }
                    if (!emailRed.equals("")) {
                        if (!bFirst) {
                            sql.append(",");
                        }
                        sql.append(" email_red_ind=").append(SQL.quote(emailRed));
                        bFirst = false;
                    }
                    if (!emailYellow.equals("")) {
                        if (!bFirst) {
                            sql.append(",");
                        }
                        sql.append(" email_yellow_ind=").append(SQL.quote(emailYellow));
                        bFirst = false;
                    }
                    if (!emailGreen.equals("")) {
                        if (!bFirst) {
                            sql.append(",");
                        }
                        sql.append(" email_green_ind=").append(SQL.quote(emailGreen));
                        bFirst = false;
                    }
                    if (nameIsUser) {
                        sql.append(" WHERE user_id=");
                    } else {
                        sql.append(" WHERE group_name=");
                    }
                    sql.append(SQL.quote(notifyName));
                    sql.append(" AND object_type=").append(SQL.quote(notifyAbout.getObjectType()));
                    sql.append(" AND object_name=").append(SQL.quote(notifyAbout.getObjectName()));
                } else {
                    if (nameIsUser) {
                        sql.append("INSERT INTO pl_user_notification(user_id,");
                    } else {
                        sql.append("INSERT INTO pl_group_notification(group_name,");
                    }
                    sql.append(" object_type, object_name, view_kpi_ind,");
                    sql.append(" email_red_ind, email_yellow_ind, email_green_ind)");
                    sql.append(" VALUES( ");
                    sql.append(SQL.quote(notifyName)).append(",");
                    sql.append(SQL.quote(notifyAbout.getObjectType())).append(",");
                    sql.append(SQL.quote(notifyAbout.getObjectName())).append(",");
                    sql.append(SQL.quote(viewKpi)).append(",");
                    sql.append(SQL.quote(emailRed)).append(",");
                    sql.append(SQL.quote(emailYellow)).append(",");
                    sql.append(SQL.quote(emailGreen)).append(")");
                }
            }
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static boolean checkUserWithGroupEmailSetting(Connection con, PLUser user, DatabaseObject dbObj, String statusType) throws SQLException {
        if (EmailNotification.checkEmailSetting(con, user.getUserId(), true, dbObj, statusType)) {
            return true;
        }
        for (Object g : user.getGroups(con)) {
            PLGroup group = (PLGroup)g;
            if (!EmailNotification.checkEmailSetting(con, group.getGroupName(), false, dbObj, statusType)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkUserEmailSetting(Connection con, PLUser user, DatabaseObject dbObj, String statusType) throws SQLException {
        return EmailNotification.checkEmailSetting(con, user.getUserId(), true, dbObj, statusType);
    }

    public static boolean checkGroupEmailSetting(Connection con, PLGroup group, DatabaseObject dbObj, String statusType) throws SQLException {
        return EmailNotification.checkEmailSetting(con, group.getGroupName(), false, dbObj, statusType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkEmailSetting(Connection con, String name, boolean isUser, DatabaseObject dbObj, String statusType) throws SQLException {
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT " + statusType + " FROM");
            if (isUser) {
                sql.append(" pl_user_notification WHERE user_id = " + SQL.quote(name));
            } else {
                sql.append(" pl_group_notification WHERE group_name = " + SQL.quote(name));
            }
            sql.append(" object_type = " + SQL.quote(dbObj.getObjectType()));
            sql.append(" AND object_name = " + SQL.quote(dbObj.getObjectName()));
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                boolean bl = rs.getString(1).equals("Y");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkDBObjStatus(Connection con, DatabaseObject dbObj) throws SQLException {
        Statement stmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT run_status FROM pl_status WHERE");
            sql.append(" object_type = " + SQL.quote(dbObj.getObjectType()));
            sql.append(" AND object_name = " + SQL.quote(dbObj.getObjectName()));
            sql.append("  ORDER BY start_date_time DESC");
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                String prefStatus = rs.getString(1);
                if (prefStatus == null) continue;
                String string = prefStatus;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EmailRecipient> findEmailRecipients(Connection con, DatabaseObject dbObj, String statusType) throws SQLException {
        ArrayList<EmailRecipient> emailRecipients = new ArrayList<EmailRecipient>();
        Statement stmt = null;
        try {
            EmailRecipient er;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT user_name, email_address FROM pl_user WHERE user_id in");
            sql.append(" (SELECT user_id FROM pl_user_notification WHERE");
            sql.append(" " + statusType + " = " + SQL.quote("Y"));
            sql.append("  AND object_type = " + SQL.quote(dbObj.getObjectType()));
            sql.append("  AND object_name = " + SQL.quote(dbObj.getObjectName()) + ")");
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                er = new EmailRecipient(rs.getString(1), rs.getString(2));
                emailRecipients.add(er);
            }
            sql.setLength(0);
            sql.append("SELECT user_name, email_address FROM pl_user WHERE user_id in");
            sql.append(" (SELECT user_id FROM user_group WHERE group_name in");
            sql.append("  (SELECT group_name FROM pl_group_notification WHERE");
            sql.append("   " + statusType + " = " + SQL.quote("Y"));
            sql.append("   AND object_type = " + SQL.quote(dbObj.getObjectType()));
            sql.append("   AND object_name = " + SQL.quote(dbObj.getObjectName()) + "))");
            rs = stmt.executeQuery(sql.toString());
            while (rs.next()) {
                er = new EmailRecipient(rs.getString(1), rs.getString(2));
                if (emailRecipients.contains(er)) continue;
                emailRecipients.add(er);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return emailRecipients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj) throws PLSecurityException, SQLException {
        sm.checkDelete(con, obj);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM pl_user_notification WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("DELETE FROM pl_user_notification_log WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("DELETE FROM pl_group_notification");
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj, String newName) throws PLSecurityException, SQLException {
        sm.checkModify(con, obj);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE pl_user_notification SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("UPDATE pl_user_notification_log SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("UPDATE pl_group_notification SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static class EmailRecipient {
        private String name;
        private String email;

        public EmailRecipient(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EmailRecipient) {
                boolean nameEquals;
                EmailRecipient other = (EmailRecipient)obj;
                boolean bl = this.name == null ? other.name == null : (nameEquals = this.name.equals(other.name));
                if (!nameEquals) {
                    return false;
                }
                return this.email == null ? other.email == null : this.email.equals(other.email);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.email.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public String toString() {
            return "<" + this.name + "> " + this.email;
        }
    }
}

