/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.MockPseudoRandom;

public class ServerUnitTest
extends FreeColTestCase {
    private static final BuildingType carpenterHouseType = ServerUnitTest.spec().getBuildingType("model.building.carpenterHouse");
    private static final BuildingType townHallType = ServerUnitTest.spec().getBuildingType("model.building.townHall");
    private static final BuildingType warehouseType = ServerUnitTest.spec().getBuildingType("model.building.depot");
    private static final GoodsType foodType = ServerUnitTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = ServerUnitTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType lumberType = ServerUnitTest.spec().getGoodsType("model.goods.lumber");
    private static final TileImprovementType road = ServerUnitTest.spec().getTileImprovementType("model.improvement.road");
    private static final TileImprovementType plow = ServerUnitTest.spec().getTileImprovementType("model.improvement.plow");
    private static final TileImprovementType clear = ServerUnitTest.spec().getTileImprovementType("model.improvement.clearForest");
    private static final TileType plains = ServerUnitTest.spec().getTileType("model.tile.plains");
    private static final TileType savannah = ServerUnitTest.spec().getTileType("model.tile.savannah");
    private static final TileType savannahForest = ServerUnitTest.spec().getTileType("model.tile.tropicalForest");
    private static final Role pioneerRole = ServerUnitTest.spec().getRole("model.role.pioneer");
    private static final Role scoutRole = ServerUnitTest.spec().getRole("model.role.scout");
    private static final UnitType colonistType = ServerUnitTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType expertFarmerType = ServerUnitTest.spec().getUnitType("model.unit.expertFarmer");
    private static final UnitType pioneerType = ServerUnitTest.spec().getUnitType("model.unit.hardyPioneer");
    private static final UnitType soldierType = ServerUnitTest.spec().getUnitType("model.unit.veteranSoldier");

    private static boolean hasImprovement(Tile tile, TileImprovementType type) {
        if (type.changeContainsTarget(tile.getType())) {
            return true;
        }
        if (tile.getTileItemContainer() != null) {
            return tile.getTileItemContainer().hasImprovement(type);
        }
        return false;
    }

    public void testToggleHorses() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(plains));
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile tile1 = game.getMap().getTile(5, 8);
        tile1.setExplored(dutch, true);
        ServerUnit scout = new ServerUnit(game, tile1, dutch, colonistType);
        ServerTestHelper.newTurn();
        ServerUnitTest.assertEquals((int)scout.getInitialMovesLeft(), (int)scout.getMovesLeft());
        int colonistMoves = scout.getMovesLeft();
        scout.changeRole(scoutRole, 1);
        ServerTestHelper.newTurn();
        ServerUnitTest.assertTrue((String)"Scout should have more moves than a colonist", (scout.getMovesLeft() > colonistMoves ? 1 : 0) != 0);
        scout.changeRole(ServerUnitTest.spec().getDefaultRole(), 0);
        ServerTestHelper.newTurn();
        ServerUnitTest.assertEquals((int)scout.getMovesLeft(), (int)colonistMoves);
    }

    public void testDoAssignedWorkHardyPioneerPlowPlain() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(plains));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile plain = game.getMap().getTile(5, 8);
        plain.setExplored(dutch, true);
        plain.setOwner(dutch);
        ServerUnit hardyPioneer = new ServerUnit(game, plain, dutch, pioneerType);
        hardyPioneer.setRoleCount(1);
        ServerUnitTest.assertFalse((boolean)ServerUnitTest.hasImprovement(plain, plow));
        ServerUnitTest.assertEquals((int)3, (int)hardyPioneer.getMovesLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer.getState()));
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer.getWorkLeft());
        ServerUnitTest.assertEquals((Object)pioneerRole, (Object)hardyPioneer.getRole());
        igc.changeWorkImprovementType(dutch, hardyPioneer, plow);
        ServerUnitTest.assertFalse((boolean)ServerUnitTest.hasImprovement(plain, plow));
        ServerUnitTest.assertEquals((int)0, (int)hardyPioneer.getMovesLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.IMPROVING), (Object)((Object)hardyPioneer.getState()));
        ServerUnitTest.assertEquals((int)5, (int)hardyPioneer.getWorkLeft());
        ServerUnitTest.assertEquals((Object)pioneerRole, (Object)hardyPioneer.getRole());
        while (hardyPioneer.getWorkLeft() > 0) {
            ServerTestHelper.newTurn();
        }
        ServerUnitTest.assertTrue((boolean)ServerUnitTest.hasImprovement(plain, plow));
        ServerUnitTest.assertEquals((int)0, (int)hardyPioneer.getMovesLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer.getState()));
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer.getWorkLeft());
        ServerUnitTest.assertEquals((Object)ServerUnitTest.spec().getDefaultRole(), (Object)hardyPioneer.getRole());
    }

    public void testColonyProfitFromEnhancement() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(plains));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Map map = game.getMap();
        map.getTile(5, 8).setExplored(dutch, true);
        map.getTile(6, 8).setExplored(dutch, true);
        Tile plain58 = map.getTile(5, 8);
        ServerUnitTest.assertEquals((int)6, (int)ServerUnitTest.spec().getInteger("model.option.badGovernmentLimit"));
        ServerUnitTest.assertEquals((int)10, (int)ServerUnitTest.spec().getInteger("model.option.veryBadGovernmentLimit"));
        ServerUnit soldier = new ServerUnit(game, map.getTile(6, 8), dutch, soldierType);
        ServerColony colony = new ServerColony(game, dutch, "New Amsterdam", soldier.getTile());
        dutch.addSettlement(colony);
        soldier.changeWorkType(foodType);
        this.nonServerBuildColony(soldier, colony);
        soldier.setLocation(colony.getColonyTile(plain58));
        ServerUnit hardyPioneer = new ServerUnit(game, plain58, dutch, pioneerType);
        ServerUnitTest.assertEquals((int)0, (int)colony.getGoodsCount(foodType));
        ServerUnitTest.assertEquals((int)2, (int)colony.getFoodConsumption());
        ServerUnitTest.assertEquals((int)8, (int)colony.getFoodProduction());
        ServerUnitTest.assertFalse((boolean)ServerUnitTest.hasImprovement(plain58, plow));
        ServerUnitTest.assertEquals((int)0, (int)colony.getProductionBonus());
        ServerUnitTest.assertEquals((String)("" + soldier.getLocation()), (Object)colony.getColonyTile(map.getTile(5, 8)), (Object)soldier.getLocation());
        ServerTestHelper.newTurn();
        ServerUnitTest.assertFalse((boolean)ServerUnitTest.hasImprovement(plain58, plow));
        ServerUnitTest.assertEquals((int)6, (int)colony.getGoodsCount(foodType));
        ServerUnitTest.assertEquals((int)2, (int)colony.getFoodConsumption());
        ServerUnitTest.assertEquals((int)0, (int)colony.getProductionBonus());
        ServerUnitTest.assertEquals((int)8, (int)colony.getFoodProduction());
        igc.changeWorkImprovementType(dutch, hardyPioneer, plow);
        int n = 0;
        while (hardyPioneer.getWorkLeft() > 0) {
            ServerTestHelper.newTurn();
            ++n;
        }
        colony.invalidateCache();
        ServerUnitTest.assertTrue((boolean)ServerUnitTest.hasImprovement(plain58, plow));
        ServerUnitTest.assertEquals((int)9, (int)colony.getFoodProduction());
        ServerUnitTest.assertEquals((int)2, (int)colony.getFoodConsumption());
        ServerUnitTest.assertEquals((int)(6 + n * 6), (int)colony.getGoodsCount(foodType));
        colony.invalidateCache();
        ServerTestHelper.newTurn();
        ServerUnitTest.assertTrue((boolean)ServerUnitTest.hasImprovement(plain58, plow));
        ServerUnitTest.assertEquals((int)9, (int)colony.getFoodProduction());
        ServerUnitTest.assertEquals((int)2, (int)colony.getFoodConsumption());
        ServerUnitTest.assertEquals((int)(6 + n * 6 + 7), (int)colony.getGoodsCount(foodType));
    }

    public void testDoAssignedWorkHardyPioneerBuildRoad() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(savannahForest));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Map map = game.getMap();
        Tile tile = map.getTile(5, 8);
        map.getTile(5, 8).setExplored(dutch, true);
        ServerUnit hardyPioneer1 = new ServerUnit(game, tile, dutch, pioneerType, pioneerRole);
        ServerUnit hardyPioneer2 = new ServerUnit(game, tile, dutch, pioneerType, pioneerRole);
        ServerUnit hardyPioneer3 = new ServerUnit(game, tile, dutch, pioneerType, pioneerRole);
        ServerUnitTest.assertEquals((boolean)false, (boolean)tile.hasRoad());
        ServerUnitTest.assertEquals((int)3, (int)hardyPioneer1.getMovesLeft());
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer1.getWorkLeft());
        ServerUnitTest.assertEquals((int)5, (int)hardyPioneer1.getRoleCount());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer1.getState()));
        ServerUnitTest.assertEquals((int)3, (int)hardyPioneer2.getMovesLeft());
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer2.getWorkLeft());
        ServerUnitTest.assertEquals((int)5, (int)hardyPioneer2.getRoleCount());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer2.getState()));
        tile.setOwner(dutch);
        igc.changeWorkImprovementType(dutch, hardyPioneer1, road);
        igc.changeWorkImprovementType(dutch, hardyPioneer2, road);
        igc.changeWorkImprovementType(dutch, hardyPioneer3, clear);
        ServerUnitTest.assertEquals((int)6, (int)hardyPioneer1.getWorkLeft());
        ServerUnitTest.assertEquals((int)6, (int)hardyPioneer2.getWorkLeft());
        ServerUnitTest.assertEquals((int)8, (int)hardyPioneer3.getWorkLeft());
        TileImprovement roadImprovement = tile.getRoad();
        while (roadImprovement.getTurnsToComplete() > 0) {
            ServerTestHelper.newTurn();
        }
        ServerUnitTest.assertTrue((boolean)tile.hasRoad());
        ServerUnitTest.assertTrue((boolean)roadImprovement.isComplete());
        ServerUnitTest.assertEquals((Object)savannahForest, (Object)tile.getType());
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer1.getWorkLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer1.getState()));
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer2.getWorkLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer2.getState()));
        ServerUnitTest.assertEquals((int)9, (int)(hardyPioneer1.getRoleCount() + hardyPioneer2.getRoleCount()));
        ServerUnitTest.assertEquals((int)3, (int)hardyPioneer3.getMovesLeft());
        ServerUnitTest.assertEquals((int)4, (int)hardyPioneer3.getWorkLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.IMPROVING), (Object)((Object)hardyPioneer3.getState()));
        ServerUnitTest.assertEquals((int)5, (int)hardyPioneer3.getRoleCount());
        while (hardyPioneer3.getWorkLeft() > 0) {
            ServerTestHelper.newTurn();
        }
        ServerUnitTest.assertEquals((Object)savannah, (Object)tile.getType());
        ServerUnitTest.assertEquals((int)0, (int)hardyPioneer3.getMovesLeft());
        ServerUnitTest.assertEquals((int)-1, (int)hardyPioneer3.getWorkLeft());
        ServerUnitTest.assertEquals((Object)((Object)Unit.UnitState.ACTIVE), (Object)((Object)hardyPioneer3.getState()));
        ServerUnitTest.assertEquals((int)4, (int)hardyPioneer3.getRoleCount());
    }

    public void testUnitGetsExperienceThroughWork() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap());
        Colony colony = this.getStandardColony();
        Unit colonist = colony.getUnitList().get(0);
        ServerUnitTest.assertEquals((String)"Colonist should not have any experience", (int)0, (int)colonist.getExperience());
        ServerUnitTest.assertEquals((String)"Colonist should be free colonist", (Object)colonistType, (Object)colonist.getType());
        WorkLocation loc = colonist.getWorkLocation();
        if (!(loc instanceof ColonyTile)) {
            colonist.setLocation(colony.getWorkLocationFor(colonist, foodType));
        }
        ServerUnitTest.assertTrue((boolean)(colonist.getLocation() instanceof ColonyTile));
        ServerUnitTest.assertNotNull((Object)colonist.getWorkType());
        ServerUnitTest.assertTrue((boolean)colonist.getWorkType().isFoodType());
        ServerTestHelper.newTurn();
        ServerUnitTest.assertTrue((String)"Colonist should have gained some experience", (colonist.getExperience() > 0 ? 1 : 0) != 0);
    }

    public void testUnitPromotionWorkingInWorkTile() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(plains));
        Colony colony = this.getStandardColony();
        ServerUnitTest.assertTrue((String)"Colony should only have 1 colonist for test setup", (colony.getUnitCount() == 1 ? 1 : 0) != 0);
        Unit colonist = colony.getUnitList().get(0);
        String errMsg = "Error setting test, colonist should not be an expert";
        ServerUnitTest.assertTrue((String)errMsg, (colonist.getType() == colonistType ? 1 : 0) != 0);
        Tile tile = colony.getTile().getNeighbourOrNull(Direction.N);
        ServerUnitTest.assertTrue((boolean)colony.getOwner().canOwnTile(tile));
        ColonyTile colonyTile = colony.getColonyTile(tile);
        if (!colonyTile.isEmpty()) {
            colonyTile.getUnitList().get(0).setLocation(colony.getBuilding(townHallType));
        }
        ServerUnitTest.assertTrue((boolean)colonyTile.canBeWorked());
        colonist.setLocation(colonyTile);
        colonist.changeWorkType(grainType);
        ServerUnitTest.assertEquals((String)"Wrong work allocation", (Object)grainType, (Object)colonist.getWorkType());
        ServerUnitTest.assertEquals((Object)colonyTile.getUnitList().get(0), (Object)colonist);
        ServerUnitTest.assertTrue((colonyTile.getTotalProductionOf(colonist.getWorkType()) > 0 ? 1 : 0) != 0);
        UnitType learn = ServerUnitTest.spec().getExpertForProducing(colonist.getWorkType());
        ServerUnitTest.assertNotNull((Object)learn);
        ServerUnitTest.assertFalse((learn == colonist.getType() ? 1 : 0) != 0);
        ServerUnitTest.assertNotNull((Object)colonist.getUnitChange("model.unitChange.experience"));
        int expectXP = 10;
        colonist.modifyExperience(expectXP);
        ServerUnitTest.assertEquals((String)"Wrong colonist experience", (int)expectXP, (int)colonist.getExperience());
        ArrayList<Integer> setValues = new ArrayList<Integer>();
        setValues.add(1);
        MockPseudoRandom mockRandom = new MockPseudoRandom(setValues, true);
        ServerTestHelper.setRandom(mockRandom);
        boolean isExpert = colonist.getType() == expertFarmerType;
        ServerUnitTest.assertFalse((String)"Unit should not be an expert", (boolean)isExpert);
        ServerTestHelper.newTurn();
        isExpert = colonist.getType() == expertFarmerType;
        ServerUnitTest.assertTrue((String)"Unit should now be an expert", (boolean)isExpert);
    }

    public void testExposeResource() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(savannahForest));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Map map = game.getMap();
        Tile tile = map.getTile(5, 8);
        tile.setOwner(dutch);
        tile.setExplored(dutch, true);
        Role pioneerRole = ServerUnitTest.spec().getRole("model.role.pioneer");
        ServerUnit hardyPioneer = new ServerUnit(game, tile, dutch, pioneerType, pioneerRole);
        igc.changeWorkImprovementType(dutch, hardyPioneer, clear);
        ServerUnitTest.assertEquals((int)8, (int)hardyPioneer.getWorkLeft());
        ServerUnitTest.assertEquals((Object)savannahForest, (Object)tile.getType());
        ServerUnitTest.assertFalse((boolean)tile.hasResource());
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ArrayList<Integer> setValues = new ArrayList<Integer>();
        setValues.add(1);
        MockPseudoRandom mockRandom = new MockPseudoRandom(setValues, true);
        ServerTestHelper.setRandom(mockRandom);
        ServerTestHelper.newTurn();
        ServerUnitTest.assertEquals((Object)savannah, (Object)tile.getType());
        ServerUnitTest.assertTrue((boolean)tile.hasResource());
    }

    public void testUnitLumberDelivery() {
        ServerGame game = ServerTestHelper.startServerGame(ServerUnitTest.getTestMap(savannahForest));
        InGameController igc = ServerTestHelper.getInGameController();
        Colony colony = this.getStandardColony(3);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        Tile tile = colony.getTile();
        Role pioneerRole = ServerUnitTest.spec().getRole("model.role.pioneer");
        ServerUnit hardyPioneer = new ServerUnit(game, tile, player, pioneerType, pioneerRole);
        igc.changeWorkImprovementType(player, hardyPioneer, clear);
        ServerUnitTest.assertEquals((int)8, (int)hardyPioneer.getWorkLeft());
        ServerUnitTest.assertEquals((Object)savannahForest, (Object)tile.getType());
        ServerUnitTest.assertEquals((Object)colony, (Object)tile.getOwningSettlement());
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        colony.removeGoods(lumberType);
        ServerTestHelper.newTurn();
        ServerUnitTest.assertEquals((String)"Lumber delivery with hardy pioneer", (int)40, (int)colony.getGoodsCount(lumberType));
        ServerUnitTest.assertTrue((boolean)CollectionUtils.none(colony.getModifiers("model.modifier.tileTypeChangeProduction")));
        colony.getBuilding(carpenterHouseType).upgrade();
        colony.getBuilding(warehouseType).upgrade();
        ServerUnitTest.assertEquals((int)1, (int)CollectionUtils.count(colony.getModifiers("model.modifier.tileTypeChangeProduction")));
        Tile tile2 = tile.getNeighbourOrNull(Direction.N);
        ServerUnitTest.assertEquals((Object)colony, (Object)tile2.getOwningSettlement());
        hardyPioneer.setLocation(tile2);
        hardyPioneer.setMovesLeft(1);
        igc.changeWorkImprovementType(player, hardyPioneer, clear);
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        ServerTestHelper.newTurn();
        colony.removeGoods(lumberType);
        ServerTestHelper.newTurn();
        ServerUnitTest.assertEquals((String)"Lumber delivered with hardy pioneer and mill", (int)120, (int)colony.getGoodsCount(lumberType));
    }
}

