/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonGeneratorImpl;
import org.eclipse.parsson.JsonPrettyGeneratorImpl;

class JsonGeneratorFactoryImpl
implements JsonGeneratorFactory {
    private final JsonContext jsonContext;

    JsonGeneratorFactoryImpl(JsonContext jsonContext) {
        this.jsonContext = jsonContext;
    }

    public JsonGenerator createGenerator(Writer writer) {
        return this.jsonContext.prettyPrinting() ? new JsonPrettyGeneratorImpl(writer, this.jsonContext) : new JsonGeneratorImpl(writer, this.jsonContext);
    }

    public JsonGenerator createGenerator(OutputStream out) {
        return this.jsonContext.prettyPrinting() ? new JsonPrettyGeneratorImpl(out, this.jsonContext) : new JsonGeneratorImpl(out, this.jsonContext);
    }

    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        return this.jsonContext.prettyPrinting() ? new JsonPrettyGeneratorImpl(out, charset, this.jsonContext) : new JsonGeneratorImpl(out, charset, this.jsonContext);
    }

    public Map<String, ?> getConfigInUse() {
        return this.jsonContext.config();
    }
}

