/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.engine.mvn;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lucee.loader.engine.mvn.RepoReader;
import lucee.loader.util.Util;
import lucee.runtime.exp.PageException;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;

public class MavenUpdateProvider {
    public static final int CONNECTION_TIMEOUT = 50000;
    public static final int READ_TIMEOUT_HEAD = 5000;
    public static final int READ_TIMEOUT_GET = 20000;
    private static final String DEFAULT_REPOSITORY_SNAPSHOT = "https://oss.sonatype.org/content/repositories/snapshots/";
    private static final String DEFAULT_REPOSITORY_RELEASES = "https://oss.sonatype.org/service/local/repositories/releases/content/";
    public static final String DEFAULT_GROUP = "org.lucee";
    public static final String DEFAULT_ARTIFACT = "lucee";
    private static String defaultRepositoryReleases;
    private static String defaultRepositorySnapshots;
    private String group;
    private String artifact;
    private String repoSnapshots;
    private String repoReleases;

    public static String getDefaultRepositoryReleases() {
        if (defaultRepositoryReleases == null) {
            String str = Util._getSystemPropOrEnvVar("lucee.mvn.repo.releases", null);
            if (!Util.isEmpty(str, true)) {
                try {
                    new URL(str.trim());
                    defaultRepositoryReleases = str.trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (defaultRepositoryReleases == null) {
                defaultRepositoryReleases = DEFAULT_REPOSITORY_RELEASES;
            }
        }
        return defaultRepositoryReleases;
    }

    public static String getDefaultRepositorySnapshots() {
        if (defaultRepositorySnapshots == null) {
            String str = Util._getSystemPropOrEnvVar("lucee.mvn.repo.snapshots", null);
            if (!Util.isEmpty(str, true)) {
                try {
                    new URL(str.trim());
                    defaultRepositorySnapshots = str.trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (defaultRepositorySnapshots == null) {
                defaultRepositorySnapshots = DEFAULT_REPOSITORY_SNAPSHOT;
            }
        }
        return defaultRepositorySnapshots;
    }

    public MavenUpdateProvider() {
        this.repoSnapshots = MavenUpdateProvider.getDefaultRepositorySnapshots();
        this.repoReleases = MavenUpdateProvider.getDefaultRepositoryReleases();
        this.group = DEFAULT_GROUP;
        this.artifact = DEFAULT_ARTIFACT;
    }

    public MavenUpdateProvider(String listProvider, String repoSnapshots, String repoReleases, String group, String artifact) {
        this.group = group;
        this.repoSnapshots = repoSnapshots;
        this.repoReleases = repoReleases;
        this.artifact = artifact;
    }

    public InputStream getCore(Version version) throws IOException, GeneralSecurityException, PageException, SAXException {
        int sc;
        HttpURLConnection conn;
        URL urlLco = null;
        URL urljar = null;
        if (version.getQualifier().endsWith("-SNAPSHOT")) {
            RepoReader repoReader = new RepoReader(this.repoSnapshots, this.group, this.artifact, version);
            Map<String, Map<String, Object>> map = repoReader.read();
            Map<String, Object> lco = map.get("lco");
            if (lco != null) {
                urlLco = new URL(MavenUpdateProvider.toString(lco.get("url")));
            }
            urljar = new URL(MavenUpdateProvider.toString(map.get("jar").get("url")));
        } else {
            String g = this.group.replace('.', '/');
            String a = this.artifact.replace('.', '/');
            String v = version.toString();
            String repo = this.repoReleases;
            if (!repo.endsWith("/")) {
                repo = repo + "/";
            }
            urlLco = new URL(repo + g + "/" + a + "/" + v + "/" + a + "-" + v + ".lco");
            urljar = new URL(repo + g + "/" + a + "/" + v + "/" + a + "-" + v + ".jar");
        }
        if (urlLco != null && (conn = MavenUpdateProvider.get(urlLco)) != null && (sc = conn.getResponseCode()) >= 200 && sc < 300) {
            return conn.getInputStream();
        }
        conn = MavenUpdateProvider.get(urljar);
        if (conn == null) {
            throw new IOException("jar [" + urljar + "] and core [" + urlLco + "] do not exist");
        }
        return MavenUpdateProvider.getFileStreamFromZipStream(conn.getInputStream());
    }

    public static InputStream getFileStreamFromZipStream(InputStream zipStream) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(zipStream);
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().equals("core/core.lco")) continue;
            Enumeration<ZipInputStream> singleStreamEnum = Collections.enumeration(Collections.singletonList(zis));
            return new SequenceInputStream(singleStreamEnum);
        }
        throw new FileNotFoundException("core/core.lco not found in zip");
    }

    public static HttpURLConnection get(URL url) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Lucee");
            connection.setConnectTimeout(50000);
            connection.setReadTimeout(20000);
            connection.connect();
            return connection;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exist(URL url) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(50000);
            connection.setReadTimeout(5000);
            connection.setRequestMethod("HEAD");
            connection.connect();
            int responseCode = connection.getResponseCode();
            boolean bl = responseCode >= 200 && responseCode < 300;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String toString(Object obj, String defaultValue) {
        if (obj == null) {
            return "";
        }
        try {
            return obj.toString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

