/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.spi.PaxDefaultLogStreamProvider;
import org.ops4j.pax.logging.spi.support.BufferingLog;
import org.ops4j.pax.logging.spi.support.BundleHelper;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FileServiceLog;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class FallbackLogFactory {
    private static ServiceRegistration<PaxDefaultLogStreamProvider> singletonStreamRegistration;
    private static ServiceReference<PaxDefaultLogStreamProvider> singletonStreamReference;
    private static PaxDefaultLogStreamProvider singletonStream;
    private static Bundle bundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PaxLogger createFallbackLog(Bundle requestingBundle, String categoryName) {
        File logFile;
        requestingBundle = BundleHelper.getCallerBundle(requestingBundle, 3);
        if (bundle == null) {
            Class<FallbackLogFactory> clazz = FallbackLogFactory.class;
            // MONITORENTER : org.ops4j.pax.logging.spi.support.FallbackLogFactory.class
            if (bundle == null) {
                Bundle b;
                bundle = b = FrameworkUtil.getBundle(PaxLogger.class);
            }
            // MONITOREXIT : clazz
        }
        BundleContext context = bundle == null ? null : bundle.getBundleContext();
        if (bundle == null) return FallbackLogFactory.createFallbackLog0(requestingBundle, null, context, categoryName);
        if (bundle.getState() != 8) {
            if (bundle.getState() != 32) return FallbackLogFactory.createFallbackLog0(requestingBundle, null, context, categoryName);
        }
        if ((logFile = FallbackLogFactory.logFile(context)) == null) return FallbackLogFactory.createFallbackLog0(requestingBundle, null, context, categoryName);
        if (context == null) return FallbackLogFactory.createFallbackLog0(requestingBundle, null, context, categoryName);
        PaxDefaultLogStreamProvider defaultStream = FallbackLogFactory.getRegisteredStream(context);
        if (defaultStream != null) {
            return FallbackLogFactory.createFallbackLog0(requestingBundle, defaultStream, context, categoryName);
        }
        Class<PaxLogger> clazz = PaxLogger.class;
        // MONITORENTER : org.ops4j.pax.logging.PaxLogger.class
        defaultStream = FallbackLogFactory.getRegisteredStream(context);
        if (defaultStream == null) {
            try {
                final PrintStream stream = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)));
                singletonStream = new PaxDefaultLogStreamProvider(){

                    @Override
                    public PrintStream stream() {
                        return stream;
                    }

                    @Override
                    public void close() throws IOException {
                        stream.close();
                    }
                };
                singletonStreamRegistration = context.registerService(PaxDefaultLogStreamProvider.class, (Object)singletonStream, null);
                defaultStream = singletonStream;
                return FallbackLogFactory.createFallbackLog0(requestingBundle, defaultStream, context, categoryName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        // MONITOREXIT : clazz
        return FallbackLogFactory.createFallbackLog0(requestingBundle, defaultStream, context, categoryName);
    }

    public static void cleanup() {
        BundleContext context;
        if (singletonStreamRegistration != null) {
            singletonStreamRegistration.unregister();
            try {
                singletonStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            singletonStreamRegistration = null;
        }
        BundleContext bundleContext = context = bundle == null ? null : bundle.getBundleContext();
        if (context != null && singletonStreamReference != null) {
            try {
                context.ungetService(singletonStreamReference);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            singletonStreamReference = null;
            singletonStream = null;
        }
    }

    private static PaxDefaultLogStreamProvider getRegisteredStream(BundleContext ctx) {
        if (singletonStreamRegistration != null) {
            return singletonStream;
        }
        if (singletonStreamReference == null) {
            singletonStreamReference = ctx.getServiceReference(PaxDefaultLogStreamProvider.class);
        }
        if (singletonStreamReference != null) {
            if (singletonStreamReference.getBundle() == null) {
                ctx.ungetService(singletonStreamReference);
                singletonStream = null;
            }
            if (singletonStream == null) {
                PaxDefaultLogStreamProvider service;
                singletonStream = service = (PaxDefaultLogStreamProvider)ctx.getService(singletonStreamReference);
            }
        }
        return singletonStream;
    }

    private static PaxLogger createFallbackLog0(Bundle bundle, PaxDefaultLogStreamProvider streamProvider, BundleContext ctx, String categoryName) {
        if (FallbackLogFactory.isBuffering(ctx)) {
            return new BufferingLog(bundle, categoryName);
        }
        if (streamProvider != null && streamProvider.stream() != null) {
            return new FileServiceLog(streamProvider.stream(), bundle, categoryName);
        }
        return new DefaultServiceLog(bundle, categoryName);
    }

    private static boolean isBuffering(BundleContext context) {
        String buffering = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.useBufferingLogFallback");
        return Boolean.parseBoolean(buffering);
    }

    private static File logFile(BundleContext context) {
        File f;
        String fileName = OsgiUtil.systemOrContextProperty(context, "org.ops4j.pax.logging.useFileLogFallback");
        if (fileName != null && (f = new File(fileName)).getParentFile().isDirectory() && (!f.exists() || f.isFile())) {
            return f;
        }
        return null;
    }
}

