/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.core.internal;

import org.apache.karaf.packages.core.internal.filter.AndExpression;
import org.apache.karaf.packages.core.internal.filter.Expression;
import org.apache.karaf.packages.core.internal.filter.FilterParser;
import org.apache.karaf.packages.core.internal.filter.NotExpression;
import org.apache.karaf.packages.core.internal.filter.SimpleItem;

class ImportDetails {
    String name;
    String minVersion;
    String maxVersion;

    public ImportDetails(String filter) {
        Expression filterExpr = new FilterParser().parse(filter);
        if (filterExpr instanceof AndExpression) {
            AndExpression andExpr = (AndExpression)filterExpr;
            for (Expression expr : andExpr.expressions) {
                this.parseSimpleItem(expr);
            }
        }
        this.parseSimpleItem(filterExpr);
    }

    private void parseSimpleItem(Expression expr) {
        SimpleItem simpleItem;
        if (expr instanceof SimpleItem) {
            simpleItem = (SimpleItem)expr;
            if ("osgi.wiring.package".equals(simpleItem.attr)) {
                this.name = simpleItem.value;
            }
            if ("version".equals(simpleItem.attr)) {
                this.minVersion = simpleItem.value;
            }
        }
        if (expr instanceof NotExpression) {
            simpleItem = (SimpleItem)((NotExpression)expr).expression;
            this.maxVersion = simpleItem.value;
        }
    }
}

