/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.StatisticsManager;
import org.traccar.model.Server;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Request;

@Path(value="health")
@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
public class HealthResource
extends BaseResource {
    @Inject
    private Config config;
    @Inject
    private StatisticsManager statisticsManager;
    @Inject
    private Storage storage;
    private static long messageLastTotal;
    private static long messageLastCheck;

    @PermitAll
    @GET
    public Response health() {
        try {
            this.checkMessages();
            this.checkDatabase();
            return Response.ok((Object)"OK").build();
        }
        catch (Exception ignore) {
            return Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMessages() {
        Class<HealthResource> clazz = HealthResource.class;
        synchronized (HealthResource.class) {
            double ratio;
            long messageCurrentTotal = this.statisticsManager.messageStoredCount();
            long messageCurrentCheck = messageCurrentTotal - messageLastTotal;
            double dropThreshold = this.config.getDouble(Keys.WEB_HEALTH_CHECK_DROP_THRESHOLD);
            if (dropThreshold > 0.0 && messageLastCheck > 0L && messageCurrentCheck > 0L && (ratio = (double)messageCurrentCheck / (double)messageLastCheck) < dropThreshold) {
                throw new IllegalStateException("Message health check failed with ratio " + ratio);
            }
            messageLastTotal = messageCurrentTotal;
            messageLastCheck = messageCurrentCheck;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void checkDatabase() throws StorageException {
        this.storage.getObject(Server.class, new Request(new Columns.All()));
    }
}

