/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;
import org.traccar.protocol.HuabaoProtocolDecoder;

public class HuabaoProtocolEncoder
extends BaseProtocolEncoder {
    public HuabaoProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), command.getDeviceId());
        ByteBuf id = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(this.getUniqueId(command.getDeviceId())));
        try {
            ByteBuf data = Unpooled.buffer();
            byte[] time = DataConverter.parseHex(new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
            switch (command.getType()) {
                case "custom": {
                    String model = this.getDeviceModel(command.getDeviceId());
                    if (model != null && Set.of("AL300", "GL100", "VL300").contains(model)) {
                        data.writeByte(1);
                        data.writeInt(61488);
                        int length = command.getString("data").length();
                        data.writeByte(length);
                        data.writeCharSequence((CharSequence)command.getString("data"), StandardCharsets.US_ASCII);
                        ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 33027, id, false, data);
                        return byteBuf;
                    }
                    if ("BSJ".equals(model)) {
                        data.writeByte(1);
                        Charset charset = Charset.isSupported("GBK") ? Charset.forName("GBK") : StandardCharsets.US_ASCII;
                        data.writeCharSequence((CharSequence)command.getString("data"), charset);
                        ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 33536, id, false, data);
                        return byteBuf;
                    }
                    ByteBuf charset = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(command.getString("data")));
                    return charset;
                }
                case "rebootDevice": {
                    data.writeByte(1);
                    data.writeByte(35);
                    data.writeByte(1);
                    data.writeByte(3);
                    ByteBuf charset = HuabaoProtocolDecoder.formatMessage(126, 784, id, false, data);
                    return charset;
                }
                case "positionPeriodic": {
                    data.writeByte(1);
                    data.writeByte(6);
                    data.writeByte(4);
                    data.writeInt(command.getInteger("frequency"));
                    ByteBuf charset = HuabaoProtocolDecoder.formatMessage(126, 784, id, false, data);
                    return charset;
                }
                case "alarmArm": 
                case "alarmDisarm": {
                    data.writeByte(1);
                    data.writeByte(36);
                    String username = "user";
                    data.writeByte(1 + username.length());
                    data.writeByte(command.getType().equals("alarmArm") ? 1 : 0);
                    data.writeCharSequence((CharSequence)username, StandardCharsets.US_ASCII);
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 784, id, false, data);
                    return byteBuf;
                }
                case "engineStop": 
                case "engineResume": {
                    if (alternative) {
                        data.writeByte(command.getType().equals("engineStop") ? 1 : 0);
                        data.writeBytes(time);
                        ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 40966, id, false, data);
                        return byteBuf;
                    }
                    if ("VL300".equals(this.getDeviceModel(command.getDeviceId()))) {
                        data.writeCharSequence((CharSequence)(command.getType().equals("engineStop") ? "#0;1" : "#0;0"), StandardCharsets.US_ASCII);
                    } else {
                        data.writeByte(command.getType().equals("engineStop") ? 240 : 241);
                    }
                    ByteBuf byteBuf = HuabaoProtocolDecoder.formatMessage(126, 33029, id, false, data);
                    return byteBuf;
                }
            }
            Object var10_20 = null;
            return var10_20;
        }
        finally {
            id.release();
        }
    }
}

