/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import org.traccar.BaseProtocolDecoder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.protocol.StarcomProtocol;
import org.traccar.session.DeviceSession;

public class StarcomProtocolDecoder
extends BaseProtocolDecoder {
    public StarcomProtocolDecoder(StarcomProtocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        sentence = sentence.substring(sentence.indexOf(124) + 1, sentence.lastIndexOf(124));
        Position position = new Position();
        position.setProtocol(this.getProtocolName());
        block44: for (String entry : sentence.split(",")) {
            int delimiter = entry.indexOf(61);
            String key = entry.substring(0, delimiter);
            String value = entry.substring(delimiter + 1);
            switch (key) {
                case "unit": {
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                    if (deviceSession == null) continue block44;
                    position.setDeviceId(deviceSession.getDeviceId());
                    continue block44;
                }
                case "gps_valid": {
                    position.setValid(Integer.parseInt(value) != 0);
                    continue block44;
                }
                case "datetime_actual": {
                    position.setTime(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(value));
                    continue block44;
                }
                case "latitude": {
                    position.setLatitude(Double.parseDouble(value));
                    continue block44;
                }
                case "longitude": {
                    position.setLongitude(Double.parseDouble(value));
                    continue block44;
                }
                case "altitude": {
                    position.setAltitude(Double.parseDouble(value));
                    continue block44;
                }
                case "velocity": {
                    position.setSpeed(UnitsConverter.knotsFromKph(Integer.parseInt(value)));
                    continue block44;
                }
                case "heading": {
                    position.setCourse(Integer.parseInt(value));
                    continue block44;
                }
                case "eventid": {
                    position.set("event", Integer.parseInt(value));
                    continue block44;
                }
                case "odometer": {
                    position.set("odometer", (long)(Double.parseDouble(value) * 1000.0));
                    continue block44;
                }
                case "satellites": {
                    position.set("sat", Integer.parseInt(value));
                    continue block44;
                }
                case "ignition": {
                    position.set("ignition", Integer.parseInt(value) != 0);
                    continue block44;
                }
                case "door": {
                    position.set("door", Integer.parseInt(value) != 0);
                    continue block44;
                }
                case "arm": {
                    position.set("armed", Integer.parseInt(value) != 0);
                    continue block44;
                }
                case "fuel": {
                    position.set("fuel", Integer.parseInt(value));
                    continue block44;
                }
                case "rpm": {
                    position.set("rpm", Integer.parseInt(value));
                    continue block44;
                }
                case "main_voltage": {
                    position.set("power", Double.parseDouble(value));
                    continue block44;
                }
                case "backup_voltage": {
                    position.set("battery", Double.parseDouble(value));
                    continue block44;
                }
                case "analog1": 
                case "analog2": 
                case "analog3": {
                    position.set("adc" + (key.charAt(key.length() - 1) - 48), Double.parseDouble(value));
                    continue block44;
                }
                default: {
                    position.set(key, value);
                }
            }
        }
        return position;
    }
}

