/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.util.WorkbookUtil;
import org.jxls.common.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.model.DeviceUtil;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.reports.common.ReportUtils;
import org.traccar.reports.model.DeviceReportSection;
import org.traccar.reports.model.StopReportItem;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class StopsReportProvider {
    private final Config config;
    private final ReportUtils reportUtils;
    private final Storage storage;

    @Inject
    public StopsReportProvider(Config config, ReportUtils reportUtils, Storage storage) {
        this.config = config;
        this.reportUtils = reportUtils;
        this.storage = storage;
    }

    public Collection<StopReportItem> getObjects(long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to) throws StorageException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<StopReportItem> result = new ArrayList<StopReportItem>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            result.addAll(this.reportUtils.detectTripsAndStops(device, from, to, StopReportItem.class));
        }
        return result;
    }

    public void getExcel(OutputStream outputStream, long userId, Collection<Long> deviceIds, Collection<Long> groupIds, Date from, Date to) throws StorageException, IOException {
        this.reportUtils.checkPeriodLimit(from, to);
        ArrayList<DeviceReportSection> devicesStops = new ArrayList<DeviceReportSection>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (Device device : DeviceUtil.getAccessibleDevices(this.storage, userId, deviceIds, groupIds)) {
            Group group;
            List<StopReportItem> stops = this.reportUtils.detectTripsAndStops(device, from, to, StopReportItem.class);
            DeviceReportSection deviceStops = new DeviceReportSection();
            deviceStops.setDeviceName(device.getName());
            sheetNames.add(WorkbookUtil.createSafeSheetName((String)deviceStops.getDeviceName()));
            if (device.getGroupId() > 0L && (group = this.storage.getObject(Group.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getGroupId())))) != null) {
                deviceStops.setGroupName(group.getName());
            }
            deviceStops.setObjects(stops);
            devicesStops.add(deviceStops);
        }
        File file = Paths.get(this.config.getString(Keys.TEMPLATES_ROOT), "export", "stops.xlsx").toFile();
        try (FileInputStream inputStream = new FileInputStream(file);){
            Context context = this.reportUtils.initializeContext(userId);
            context.putVar("devices", devicesStops);
            context.putVar("sheetNames", sheetNames);
            context.putVar("from", (Object)from);
            context.putVar("to", (Object)to);
            this.reportUtils.processTemplateWithSheets(inputStream, outputStream, context);
        }
    }
}

