/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;

public class SplitSegment {
    private LineSegment seg;
    private double segLen;
    private Coordinate splitPt;
    private double minimumLen = 0.0;

    private static Coordinate pointAlongReverse(LineSegment seg, double segmentLengthFraction) {
        Coordinate coord = new Coordinate();
        coord.x = seg.p1.x - segmentLengthFraction * (seg.p1.x - seg.p0.x);
        coord.y = seg.p1.y - segmentLengthFraction * (seg.p1.y - seg.p0.y);
        return coord;
    }

    public SplitSegment(LineSegment seg) {
        this.seg = seg;
        this.segLen = seg.getLength();
    }

    public void setMinimumLength(double minLen) {
        this.minimumLen = minLen;
    }

    public Coordinate getSplitPoint() {
        return this.splitPt;
    }

    public void splitAt(double length, Coordinate endPt) {
        double actualLen = this.getConstrainedLength(length);
        double frac = actualLen / this.segLen;
        this.splitPt = endPt.equals2D(this.seg.p0) ? this.seg.pointAlong(frac) : SplitSegment.pointAlongReverse(this.seg, frac);
    }

    public void splitAt(Coordinate pt) {
        double minFrac = this.minimumLen / this.segLen;
        if (pt.distance(this.seg.p0) < this.minimumLen) {
            this.splitPt = this.seg.pointAlong(minFrac);
            return;
        }
        if (pt.distance(this.seg.p1) < this.minimumLen) {
            this.splitPt = SplitSegment.pointAlongReverse(this.seg, minFrac);
            return;
        }
        this.splitPt = pt;
    }

    private double getConstrainedLength(double len) {
        if (len < this.minimumLen) {
            return this.minimumLen;
        }
        return len;
    }
}

