/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.DiscriminatorState;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.TypeFactory;
import java.util.ArrayList;
import java.util.List;

public class OneOfValidator
extends BaseKeywordValidator {
    private final List<Schema> schemas;

    public OneOfValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.ONE_OF, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.schemaContext.getSchemaRegistryConfig());
            throw new SchemaException(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size = schemaNode.size();
        this.schemas = new ArrayList<Schema>(size);
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            this.schemas.add(schemaContext.newSchema(schemaLocation.append(i), childNode, parentSchema));
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        int numberOfValidSchema = 0;
        int index = 0;
        ArrayList<String> indexes = null;
        List<Error> existingErrors = executionContext.getErrors();
        ArrayList<Error> allErrors = null;
        ArrayList<Error> discriminatorErrors = null;
        ArrayList<Error> subSchemaErrors = new ArrayList<Error>();
        executionContext.setErrors(subSchemaErrors);
        boolean failFast = executionContext.isFailFast();
        Boolean canShortCircuit = null;
        int schemaIndex = 0;
        try {
            DiscriminatorState state;
            executionContext.setFailFast(false);
            for (Schema schema : this.schemas) {
                subSchemaErrors.clear();
                executionContext.evaluationPathAddLast(schemaIndex);
                try {
                    if (!walk) {
                        schema.validate(executionContext, node, rootNode, instanceLocation);
                    } else {
                        schema.walk(executionContext, node, rootNode, instanceLocation, true);
                    }
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
                ++schemaIndex;
                if (subSchemaErrors.isEmpty()) {
                    ++numberOfValidSchema;
                    if (indexes == null) {
                        indexes = new ArrayList<String>();
                    }
                    indexes.add(Integer.toString(index));
                }
                if (numberOfValidSchema > 1) {
                    if (canShortCircuit == null) {
                        canShortCircuit = this.canShortCircuit(executionContext);
                    }
                    if (canShortCircuit.booleanValue()) break;
                }
                if (this.schemaContext.isDiscriminatorKeywordEnabled()) {
                    boolean discriminatorMatchFound = false;
                    DiscriminatorState discriminator = executionContext.getDiscriminatorMapping().get(instanceLocation);
                    JsonNode refNode = schema.getSchemaNode().get("$ref");
                    if (discriminator != null && refNode != null && discriminator.hasDiscriminatingValue()) {
                        discriminatorMatchFound = discriminator.matches(refNode.asText());
                        if (discriminatorMatchFound && !subSchemaErrors.isEmpty()) {
                            discriminatorErrors = new ArrayList<Error>(subSchemaErrors);
                            allErrors = null;
                        }
                    } else if (discriminatorErrors == null) {
                        if (allErrors == null) {
                            allErrors = new ArrayList();
                        }
                        allErrors.addAll(subSchemaErrors);
                    }
                } else if (!subSchemaErrors.isEmpty() && this.reportChildErrors(executionContext)) {
                    if (allErrors == null) {
                        allErrors = new ArrayList<Error>();
                    }
                    allErrors.addAll(subSchemaErrors);
                }
                ++index;
            }
            if (this.schemaContext.isDiscriminatorKeywordEnabled() && (state = executionContext.getDiscriminatorMapping().get(instanceLocation)) != null && !state.hasMatchedSchema() && state.hasDiscriminatingValue()) {
                existingErrors.add(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword("discriminator")).instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).messageKey("discriminator.oneOf.no_match_found")).arguments(state.getDiscriminatingValue())).build());
            }
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        if (numberOfValidSchema != 1) {
            Error message = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).messageKey(numberOfValidSchema > 1 ? "oneOf.indexes" : "oneOf")).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(Integer.toString(numberOfValidSchema), numberOfValidSchema > 1 ? String.join((CharSequence)", ", indexes) : "")).build();
            existingErrors.add(message);
            if (discriminatorErrors != null) {
                existingErrors.addAll(discriminatorErrors);
            } else if (allErrors != null) {
                existingErrors.addAll(allErrors);
            }
        }
        executionContext.setErrors(existingErrors);
    }

    protected boolean reportChildErrors(ExecutionContext executionContext) {
        return !executionContext.getExecutionConfig().isFailFast();
    }

    protected boolean canShortCircuit(ExecutionContext executionContext) {
        if (this.hasUnevaluatedItemsInEvaluationPath(executionContext)) {
            return false;
        }
        if (this.hasUnevaluatedPropertiesInEvaluationPath(executionContext)) {
            return false;
        }
        return !executionContext.getExecutionConfig().isAnnotationCollectionEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node != null) {
            this.validate(executionContext, node, rootNode, instanceLocation, true);
        } else {
            int schemaIndex = 0;
            for (Schema schema : this.schemas) {
                executionContext.evaluationPathAddLast(schemaIndex);
                try {
                    schema.walk(executionContext, node, rootNode, instanceLocation, false);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
                ++schemaIndex;
            }
        }
    }

    @Override
    public void preloadSchema() {
        for (Schema schema : this.schemas) {
            schema.initializeValidators();
        }
    }
}

