/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.common.base.Preconditions;

public abstract class StateCheckingResponseObserver<V>
implements ResponseObserver<V> {
    private boolean isStarted;
    private boolean isClosed;

    @Override
    public final void onStart(StreamController controller) {
        Preconditions.checkState((!this.isStarted ? 1 : 0) != 0, (String)"%s is already started.", this.getClass());
        this.isStarted = true;
        this.onStartImpl(controller);
    }

    @Override
    public final void onResponse(V response) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"%s received a response after being closed.", this.getClass());
        this.onResponseImpl(response);
    }

    @Override
    public final void onComplete() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"%s tried to double close.", this.getClass());
        this.isClosed = true;
        this.onCompleteImpl();
    }

    @Override
    public final void onError(Throwable t) {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (String)"%s received error after being closed", (Object)t, this.getClass());
        this.isClosed = true;
        this.onErrorImpl(t);
    }

    protected abstract void onStartImpl(StreamController var1);

    protected abstract void onResponseImpl(V var1);

    protected abstract void onErrorImpl(Throwable var1);

    protected abstract void onCompleteImpl();
}

