/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.spi.internal.signer;

import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.http.auth.spi.signer.PayloadChecksumStore;

@SdkInternalApi
@ThreadSafe
public class DefaultPayloadChecksumStore
implements PayloadChecksumStore {
    private final ConcurrentHashMap<String, byte[]> cache = new ConcurrentHashMap();

    @Override
    public byte[] putChecksumValue(ChecksumAlgorithm algorithm, byte[] value) {
        return this.cache.put(algorithm.algorithmId(), value);
    }

    @Override
    public byte[] getChecksumValue(ChecksumAlgorithm algorithm) {
        return this.cache.get(algorithm.algorithmId());
    }

    @Override
    public boolean containsChecksumValue(ChecksumAlgorithm algorithm) {
        return this.cache.containsKey(algorithm.algorithmId());
    }
}

