/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscCompoundQueue;
import org.jctools.queues.MpscLinkedQueue;
import org.jctools.queues.SpmcArrayQueue;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.queues.SpscLinkedQueue;
import org.jctools.queues.spec.ConcurrentQueueSpec;
import org.jctools.queues.spec.Ordering;

public class QueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                if (qs.ordering != Ordering.NONE) {
                    return new MpscArrayQueue(qs.capacity);
                }
                return new MpscCompoundQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcArrayQueue(qs.capacity);
            }
            return new MpmcArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedQueue();
        }
        if (qs.isMpsc()) {
            return MpscLinkedQueue.newMpscLinkedQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

