/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.glassfish.jersey.internal.AbstractRuntimeDelegate;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.WebServerFactory;
import org.glassfish.jersey.server.spi.WebServer;

public class RuntimeDelegateImpl
extends AbstractRuntimeDelegate {
    public RuntimeDelegateImpl() {
        super(new MessagingBinders.HeaderDelegateProviders(RuntimeType.SERVER).getHeaderDelegateProviders());
    }

    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (application == null) {
            throw new IllegalArgumentException("application is null.");
        }
        return ContainerFactory.createContainer(endpointType, application);
    }

    public JerseySeBootstrapConfiguration.Builder createConfigurationBuilder() {
        return JerseySeBootstrapConfiguration.builder();
    }

    public CompletableFuture<SeBootstrap.Instance> bootstrap(Application application, SeBootstrap.Configuration configuration) {
        return CompletableFuture.supplyAsync(() -> {
            Class httpServerClass = configuration.hasProperty("jersey.config.server.bootstrap.webserver.class") ? (Class)configuration.property("jersey.config.server.bootstrap.webserver.class") : WebServer.class;
            Object webServer = WebServerFactory.createServer(httpServerClass, application, configuration);
            return this.instance(configuration, (WebServer)webServer);
        });
    }

    public CompletableFuture<SeBootstrap.Instance> bootstrap(Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
        return CompletableFuture.supplyAsync(() -> {
            Class httpServerClass = configuration.hasProperty("jersey.config.server.bootstrap.webserver.class") ? (Class)configuration.property("jersey.config.server.bootstrap.webserver.class") : WebServer.class;
            Object webServer = WebServerFactory.createServer(httpServerClass, applicationClass, configuration);
            return this.instance(configuration, (WebServer)webServer);
        });
    }

    private SeBootstrap.Instance instance(final SeBootstrap.Configuration configuration, final WebServer _webServer) {
        return new SeBootstrap.Instance(){
            final WebServer webServer;
            {
                this.webServer = _webServer;
            }

            public final JerseySeBootstrapConfiguration configuration() {
                return JerseySeBootstrapConfiguration.from(name -> {
                    switch (name) {
                        case "jakarta.ws.rs.SeBootstrap.Port": {
                            return this.webServer.port();
                        }
                        case "jersey.config.server.bootstrap.webserver.class": {
                            return this.webServer.getClass();
                        }
                    }
                    return configuration.property(name);
                });
            }

            public final CompletionStage<SeBootstrap.Instance.StopResult> stop() {
                return this.webServer.stop().thenApply(nativeResult -> new SeBootstrap.Instance.StopResult(){

                    public final <T> T unwrap(Class<T> nativeClass) {
                        return nativeClass.cast(nativeResult);
                    }
                });
            }

            public final <T> T unwrap(Class<T> nativeClass) {
                return nativeClass.isInstance(this.webServer) ? nativeClass.cast(this.webServer) : this.webServer.unwrap(nativeClass);
            }
        };
    }
}

