/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RetryConfig {
    private static final int INITIAL_INTERVAL_MILLIS = 500;
    private final List<Integer> retryStatusCodes;
    private final boolean retryOnIOExceptions;
    private final int maxRetries;
    private final Sleeper sleeper;
    private final ExponentialBackOff.Builder backOffBuilder;

    private RetryConfig(Builder builder) {
        this.retryStatusCodes = builder.retryStatusCodes != null ? ImmutableList.copyOf((Collection)builder.retryStatusCodes) : ImmutableList.of();
        this.retryOnIOExceptions = builder.retryOnIOExceptions;
        Preconditions.checkArgument((builder.maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must not be negative");
        this.maxRetries = builder.maxRetries;
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)builder.sleeper);
        this.backOffBuilder = new ExponentialBackOff.Builder().setInitialIntervalMillis(500).setMaxIntervalMillis(builder.maxIntervalMillis).setMultiplier(builder.backOffMultiplier).setRandomizationFactor(0.0);
        this.backOffBuilder.build();
    }

    List<Integer> getRetryStatusCodes() {
        return this.retryStatusCodes;
    }

    boolean isRetryOnIOExceptions() {
        return this.retryOnIOExceptions;
    }

    int getMaxRetries() {
        return this.maxRetries;
    }

    int getMaxIntervalMillis() {
        return this.backOffBuilder.getMaxIntervalMillis();
    }

    double getBackOffMultiplier() {
        return this.backOffBuilder.getMultiplier();
    }

    Sleeper getSleeper() {
        return this.sleeper;
    }

    BackOff newBackOff() {
        return this.backOffBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Integer> retryStatusCodes;
        private boolean retryOnIOExceptions;
        private int maxRetries;
        private int maxIntervalMillis = (int)TimeUnit.MINUTES.toMillis(2L);
        private double backOffMultiplier = 2.0;
        private Sleeper sleeper = Sleeper.DEFAULT;

        private Builder() {
        }

        public Builder setRetryStatusCodes(List<Integer> retryStatusCodes) {
            this.retryStatusCodes = retryStatusCodes;
            return this;
        }

        public Builder setRetryOnIOExceptions(boolean retryOnIOExceptions) {
            this.retryOnIOExceptions = retryOnIOExceptions;
            return this;
        }

        public Builder setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public Builder setBackOffMultiplier(double backOffMultiplier) {
            this.backOffMultiplier = backOffMultiplier;
            return this;
        }

        @VisibleForTesting
        Builder setSleeper(Sleeper sleeper) {
            this.sleeper = sleeper;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this);
        }
    }
}

